/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands.subcommands;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.commands.MessagesBase;
import io.github.arcaneplugins.levelledmobs.commands.MessagesHelper;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.SpawnerBaseClass;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.AbstractCommandAPICommand;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.CommandAPICommand;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.SuggestionInfo;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.Argument;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.ListArgumentBuilder;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.executors.CommandArguments;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.executors.ExecutorType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.util.PaperUtils;
import io.github.arcaneplugins.levelledmobs.util.SpigotUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerEggCommand;", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerBaseClass;", "<init>", "()V", "createInstance", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/CommandAPICommand;", "processResults", "", "sender", "Lorg/bukkit/command/CommandSender;", "input", "", "allEggOptions", "", "generateEgg", "info", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerBaseClass$CustomSpawnerInfo;", "levelledmobs-plugin"})
public final class SpawnerEggCommand
extends SpawnerBaseClass {
    @NotNull
    public static final SpawnerEggCommand INSTANCE = new SpawnerEggCommand();
    @NotNull
    private static final List<String> allEggOptions;

    private SpawnerEggCommand() {
    }

    @NotNull
    public final CommandAPICommand createInstance() {
        String commandName = "spawner-egg";
        String commandPermission = "levelledmobs.command.spawner-egg";
        String commandDescription = "Various commands for creating spawner egg.";
        if (!LevelledMobs.Companion.getInstance().getVer().isRunningPaper()) {
            Object Impl = ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(commandName).withPermission(commandPermission)).withShortDescription(commandDescription)).withFullDescription(commandPermission)).executes(SpawnerEggCommand::createInstance$lambda$0, new ExecutorType[0]);
            Intrinsics.checkNotNullExpressionValue(Impl, "executes(...)");
            return (CommandAPICommand)Impl;
        }
        Argument[] argumentArray = new Argument[]{new ListArgumentBuilder("values").skipListValidation(true).withList(SpawnerEggCommand::createInstance$lambda$2).withStringMapper().buildGreedy()};
        AbstractCommandAPICommand abstractCommandAPICommand = ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(commandName).withPermission(commandPermission)).withShortDescription(commandDescription)).withFullDescription(commandPermission)).executes(SpawnerEggCommand::createInstance$lambda$1, new ExecutorType[0])).withOptionalArguments(argumentArray);
        Intrinsics.checkNotNullExpressionValue(abstractCommandAPICommand, "withOptionalArguments(...)");
        return (CommandAPICommand)abstractCommandAPICommand;
    }

    private final void processResults(CommandSender sender, String input) {
        int i;
        List<String> args2 = Utils.INSTANCE.splitStringWithQuotes(input);
        boolean hasGivePlayer = false;
        int n = args2.size();
        for (int i2 = 2; i2 < n; ++i2) {
            if (!StringsKt.equals("/giveplayer", args2.get(i2), true)) continue;
            hasGivePlayer = true;
            break;
        }
        if (!hasGivePlayer && !(sender instanceof Player)) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawn_egg.no-player");
            return;
        }
        this.setHadInvalidArg(false);
        SpawnerBaseClass.CustomSpawnerInfo info = new SpawnerBaseClass.CustomSpawnerInfo();
        if (sender instanceof Player) {
            info.setPlayer((Player)sender);
        }
        int n2 = args2.size();
        for (i = 0; i < n2; ++i) {
            String arg = args2.get(i);
            if (!StringsKt.equals("/nolore", arg, true)) continue;
            info.setNoLore(true);
            break;
        }
        n2 = allEggOptions.size() - 1;
        block24: for (i = 0; i < n2; ++i) {
            boolean mustBeANumber = i > 4;
            String command = allEggOptions.get(i);
            String foundValue = this.getArgValue(command, args2, mustBeANumber);
            if (this.getHadInvalidArg()) {
                return;
            }
            CharSequence charSequence = foundValue;
            if (charSequence == null || charSequence.length() == 0) continue;
            switch (command) {
                case "/name": {
                    info.setCustomName(foundValue);
                    continue block24;
                }
                case "/customdropid": {
                    info.setCustomDropId(foundValue);
                    continue block24;
                }
                case "/lore": {
                    info.setCustomLore(foundValue);
                    continue block24;
                }
                case "/entity": {
                    try {
                        String string = foundValue;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                        String string2 = string.toUpperCase(locale);
                        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
                        info.setSpawnType(EntityType.valueOf((String)string2));
                        continue block24;
                    }
                    catch (Exception ignored) {
                        CommandSender commandSender = this.getCommandSender();
                        Intrinsics.checkNotNull(commandSender);
                        commandSender.sendMessage("Invalid spawn type: " + foundValue);
                        return;
                    }
                }
                case "/minlevel": {
                    info.setMinLevel(Integer.parseInt(foundValue));
                    continue block24;
                }
                case "/maxlevel": {
                    info.setMaxLevel(Integer.parseInt(foundValue));
                    continue block24;
                }
                case "/giveplayer": {
                    if (((CharSequence)foundValue).length() == 0) {
                        MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawn_egg.no-player-specified");
                        return;
                    }
                    try {
                        info.setPlayer(Bukkit.getPlayer((String)foundValue));
                    }
                    catch (Exception e) {
                        MessagesHelper.INSTANCE.showMessage(sender, "common.player-offline", "%player%", foundValue);
                        return;
                    }
                    if (info.getPlayer() != null) continue block24;
                    MessagesHelper.INSTANCE.showMessage(sender, "common.player-offline", "%player%", foundValue);
                    return;
                }
            }
        }
        if (info.getMinLevel() == -1 || info.getMaxLevel() == -1 || info.getSpawnType() == EntityType.UNKNOWN) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawn_egg.no-level-specified");
            return;
        }
        if (info.getPlayer() == null) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawn_egg.no-player");
            return;
        }
        this.generateEgg(sender, info);
    }

    private final void generateEgg(CommandSender sender, SpawnerBaseClass.CustomSpawnerInfo info) {
        String materialName;
        Material material;
        if (info.getCustomName() != null) {
            info.setCustomName(MessageUtils.INSTANCE.colorizeAll(info.getCustomName()));
        }
        if ((material = Material.getMaterial((String)(materialName = info.getSpawnType().name() + "_SPAWN_EGG"))) == null) {
            CommandSender commandSender = this.getCommandSender();
            Intrinsics.checkNotNull(commandSender);
            commandSender.sendMessage("Invalid material: " + materialName);
            return;
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            SpawnerBaseClass.Companion.setMetaItems(meta, info, "LM Spawn Egg");
            meta.getPersistentDataContainer().set(NamespacedKeys.INSTANCE.getSpawnerEgg(), PersistentDataType.INTEGER, (Object)1);
            meta.getPersistentDataContainer().set(NamespacedKeys.INSTANCE.getKeySpawnerMinLevel(), PersistentDataType.INTEGER, (Object)info.getMinLevel());
            meta.getPersistentDataContainer().set(NamespacedKeys.INSTANCE.getKeySpawnerMaxLevel(), PersistentDataType.INTEGER, (Object)info.getMaxLevel());
            CharSequence charSequence = info.getCustomDropId();
            if (!(charSequence == null || charSequence.length() == 0)) {
                PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId();
                String string = info.getCustomDropId();
                Intrinsics.checkNotNull(string);
                persistentDataContainer.set(namespacedKey, PersistentDataType.STRING, (Object)string);
            }
            if (info.getSpawnType() != EntityType.UNKNOWN) {
                meta.getPersistentDataContainer().set(NamespacedKeys.INSTANCE.getKeySpawnerSpawnType(), PersistentDataType.STRING, (Object)info.getSpawnType().toString());
            }
            if (info.getCustomName() != null) {
                PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getKeySpawnerCustomName();
                String string = info.getCustomName();
                Intrinsics.checkNotNull(string);
                persistentDataContainer.set(namespacedKey, PersistentDataType.STRING, (Object)string);
            }
            item.setItemMeta(meta);
        }
        Player player = info.getPlayer();
        Intrinsics.checkNotNull(player);
        int useInvSlotNum = player.getInventory().getHeldItemSlot();
        Player player2 = info.getPlayer();
        Intrinsics.checkNotNull(player2);
        if (player2.getInventory().getItem(useInvSlotNum) != null) {
            useInvSlotNum = -1;
        }
        if (useInvSlotNum == -1) {
            for (int i = 0; i < 36; ++i) {
                Player player3 = info.getPlayer();
                Intrinsics.checkNotNull(player3);
                if (player3.getInventory().getItem(i) != null) continue;
                useInvSlotNum = i;
                break;
            }
        }
        if (useInvSlotNum == -1) {
            Player player4 = info.getPlayer();
            Intrinsics.checkNotNull(player4);
            String string = player4.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawner.inventory-full", string, "");
            return;
        }
        Player player5 = info.getPlayer();
        Intrinsics.checkNotNull(player5);
        player5.getInventory().setItem(useInvSlotNum, item);
        String playerName = LevelledMobs.Companion.getInstance().getVer().isRunningPaper() ? PaperUtils.INSTANCE.getPlayerDisplayName(info.getPlayer()) : SpigotUtils.INSTANCE.getPlayerDisplayName(info.getPlayer());
        String[] stringArray = new String[]{"%minlevel%", "%maxlevel%", "%playername%", "%entitytype%"};
        String[] stringArray2 = stringArray;
        stringArray = new String[]{String.valueOf(info.getMinLevel()), String.valueOf(info.getMaxLevel()), playerName, info.getSpawnType().name()};
        List<String> message = MessagesBase.getMessage("command.levelledmobs.spawn_egg.give-message-console", stringArray2, stringArray);
        if (!((Collection)message).isEmpty()) {
            String consoleMsg = StringsKt.replace$default(message.get(0), LevelledMobs.Companion.getInstance().getConfigUtils().getPrefix() + " ", "&r", false, 4, null);
            Log.INSTANCE.inf(consoleMsg);
        }
        stringArray = new String[]{"%minlevel%", "%maxlevel%", "%playername%", "%entitytype%"};
        String[] stringArray3 = stringArray;
        stringArray = new String[]{String.valueOf(info.getMinLevel()), String.valueOf(info.getMaxLevel()), playerName, info.getSpawnType().name()};
        Player player6 = info.getPlayer();
        Intrinsics.checkNotNull(player6);
        this.showMessage("command.levelledmobs.spawn_egg.give-message", stringArray3, stringArray, (CommandSender)player6);
    }

    private static final void createInstance$lambda$0(CommandSender sender, CommandArguments commandArguments) {
        Intrinsics.checkNotNull(sender);
        MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawn_egg.no-paper");
    }

    private static final void createInstance$lambda$1(CommandSender sender, CommandArguments args2) {
        if (args2.argsMap().isEmpty()) {
            Intrinsics.checkNotNull(sender);
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawn_egg.usage");
        } else {
            Intrinsics.checkNotNull(sender);
            String string = args2.rawArgs()[0];
            Intrinsics.checkNotNullExpressionValue(string, "get(...)");
            INSTANCE.processResults(sender, string);
        }
    }

    private static final Collection createInstance$lambda$2(SuggestionInfo info) {
        Intrinsics.checkNotNull(info);
        return INSTANCE.buildTabSuggestions(allEggOptions, info);
    }

    static {
        String[] stringArray = new String[]{"/name", "/customdropid", "/entity", "/giveplayer", "/lore", "/minlevel", "/maxlevel", "/nolore"};
        allEggOptions = CollectionsKt.mutableListOf(stringArray);
    }
}

