/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands.subcommands;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.MainCompanion;
import io.github.arcaneplugins.levelledmobs.commands.MessagesHelper;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.AbstractCommandAPICommand;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.CommandAPICommand;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.SuggestionInfo;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.Argument;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.ListArgumentBuilder;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.executors.CommandArguments;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.executors.ExecutorType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.misc.CachedModalList;
import io.github.arcaneplugins.levelledmobs.misc.KillSkipConditions;
import io.github.arcaneplugins.levelledmobs.misc.RequestedLevel;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Husk;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.PiglinAbstract;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016H\u0002J \u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J0\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00132\u0006\u0010\u001c\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0018H\u0002J\u001a\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020 H\u0002\u00a8\u0006$"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/KillSubcommand;", "", "<init>", "()V", "createInstance", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/CommandAPICommand;", "processCmd", "", "sender", "Lorg/bukkit/command/CommandSender;", "input", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/executors/CommandArguments;", "isAll", "", "processKillAll", "opts", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/KillSubcommand$Options;", "processKillNear", "buildTabSuggestions", "", "", "info", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/SuggestionInfo;", "getLevelFromCommand", "Lio/github/arcaneplugins/levelledmobs/misc/RequestedLevel;", "args", "worlds", "Lorg/bukkit/World;", "useNoDrops", "rl", "skipKillingEntity", "livingEntity", "Lorg/bukkit/entity/LivingEntity;", "isMobConverting", "mob", "Options", "levelledmobs-plugin"})
public final class KillSubcommand {
    @NotNull
    public static final KillSubcommand INSTANCE = new KillSubcommand();

    private KillSubcommand() {
    }

    @NotNull
    public final CommandAPICommand createInstance() {
        CommandAPICommand[] commandAPICommandArray = new CommandAPICommand[1];
        Argument[] argumentArray = new Argument[]{new ListArgumentBuilder("values").skipListValidation(true).withList(KillSubcommand::createInstance$lambda$2).withStringMapper().buildGreedy()};
        commandAPICommandArray[0] = ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("all").withPermission("levelledmobs.command.kill.all")).executes(KillSubcommand::createInstance$lambda$1, new ExecutorType[0])).withOptionalArguments(argumentArray);
        CommandAPICommand commandAPICommand = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("kill").withPermission("levelledmobs.command.kill")).withShortDescription("Various commands for killing LevelledMobs mobs.")).withFullDescription("Various commands for killing LevelledMobs mobs.")).executes(KillSubcommand::createInstance$lambda$0, new ExecutorType[0])).withSubcommands(commandAPICommandArray);
        commandAPICommandArray = new CommandAPICommand[1];
        argumentArray = new Argument[]{new ListArgumentBuilder("values").skipListValidation(true).withList(KillSubcommand::createInstance$lambda$4).withStringMapper().buildGreedy()};
        commandAPICommandArray[0] = ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("near").withPermission("levelledmobs.command.kill.all")).executes(KillSubcommand::createInstance$lambda$3, new ExecutorType[0])).withOptionalArguments(argumentArray);
        AbstractCommandAPICommand abstractCommandAPICommand = commandAPICommand.withSubcommands(commandAPICommandArray);
        Intrinsics.checkNotNullExpressionValue(abstractCommandAPICommand, "withSubcommands(...)");
        return (CommandAPICommand)abstractCommandAPICommand;
    }

    private final void processCmd(CommandSender sender, CommandArguments input, boolean isAll) {
        if (LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            sender.sendMessage("Sorry this command doesn't work in Folia");
            return;
        }
        String values2 = input.rawArgsMap().get("values");
        if (values2 == null) {
            if (sender instanceof Player) {
                if (isAll) {
                    World[] worldArray = new World[]{((Player)sender).getWorld()};
                    this.processKillAll(sender, CollectionsKt.mutableListOf(worldArray), false, null);
                } else {
                    MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.kill.near.usage");
                }
            } else {
                MessagesHelper.INSTANCE.showMessage(sender, isAll ? "command.levelledmobs.kill.all.usage-console" : "command.levelledmobs.kill.near.usage-console");
            }
            return;
        }
        List<String> args2 = Utils.INSTANCE.splitStringWithQuotes(values2);
        boolean useNoDrops = false;
        RequestedLevel rl = this.getLevelFromCommand(sender, args2);
        List newArgs = new ArrayList();
        if (rl != null && rl.getHadInvalidArguments()) {
            return;
        }
        int rlFlag = -1;
        int n = args2.size();
        for (int i = 0; i < n; ++i) {
            String checkArg = args2.get(i);
            if (StringsKt.equals("/nodrops", checkArg, true)) {
                useNoDrops = true;
                continue;
            }
            if (StringsKt.equals("/levels", checkArg, true)) {
                rlFlag = i + 1;
                continue;
            }
            if (i == rlFlag) continue;
            newArgs.add(checkArg);
        }
        Options options = new Options(newArgs, useNoDrops, rl);
        if (isAll) {
            this.processKillAll(sender, options);
        } else {
            this.processKillNear(sender, options);
        }
    }

    private final void processKillAll(CommandSender sender, Options opts) {
        String useArg = "";
        int n = opts.getArgs().size();
        for (int i = 0; i < n; ++i) {
            if (StringsKt.startsWith$default(opts.getArgs().get(i), "/", false, 2, null)) continue;
            useArg = opts.getArgs().get(i);
        }
        if (((CharSequence)useArg).length() == 0) {
            if (sender instanceof Player) {
                World[] i = new World[]{((Player)sender).getWorld()};
                this.processKillAll(sender, CollectionsKt.mutableListOf(i), opts.getUseNoDrops(), opts.getRequestedLevel());
            } else {
                MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.kill.all.usage-console");
            }
        } else {
            if (Intrinsics.areEqual(useArg, "*")) {
                List list = Bukkit.getWorlds();
                Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
                this.processKillAll(sender, list, opts.getUseNoDrops(), opts.getRequestedLevel());
                return;
            }
            World world = Bukkit.getWorld((String)useArg);
            if (world == null) {
                MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.kill.all.invalid-world", "%world%", useArg);
                return;
            }
            World[] worldArray = new World[]{world};
            this.processKillAll(sender, CollectionsKt.mutableListOf(worldArray), opts.getUseNoDrops(), opts.getRequestedLevel());
        }
    }

    private final void processKillNear(CommandSender sender, Options opts) {
        int minRadius;
        if (!(sender instanceof BlockCommandSender) && !(sender instanceof Player)) {
            MessagesHelper.INSTANCE.showMessage(sender, "common.players-only");
            return;
        }
        if (opts.getArgs().isEmpty()) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.kill.near.usage");
            return;
        }
        int radius = 0;
        try {
            radius = Integer.parseInt(opts.getArgs().get(0));
        }
        catch (NumberFormatException exception) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.kill.near.invalid-radius", "%radius%", opts.getArgs().get(0));
            return;
        }
        int maxRadius = 1000;
        if (radius > maxRadius) {
            radius = maxRadius;
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.kill.near.invalid-radius-max", "%maxRadius%", String.valueOf(maxRadius));
        }
        if (radius < (minRadius = 1)) {
            radius = minRadius;
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.kill.near.invalid-radius-min", "%minRadius%", String.valueOf(minRadius));
        }
        int killed = 0;
        int skipped = 0;
        Collection mobsToKill = null;
        if (sender instanceof BlockCommandSender) {
            Block block = ((BlockCommandSender)sender).getBlock();
            Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
            Block block2 = block;
            mobsToKill = block2.getWorld().getNearbyEntities(block2.getLocation(), (double)radius, (double)radius, (double)radius);
        } else {
            mobsToKill = ((Player)sender).getNearbyEntities((double)radius, (double)radius, (double)radius);
        }
        for (Entity entity : mobsToKill) {
            if (!(entity instanceof LivingEntity) || !LevelledMobs.Companion.getInstance().getLevelInterface().isLevelled((LivingEntity)entity)) continue;
            if (this.skipKillingEntity((LivingEntity)entity, opts.getRequestedLevel())) {
                ++skipped;
                continue;
            }
            ((LivingEntity)entity).setMetadata("noCommands", (MetadataValue)new FixedMetadataValue((Plugin)LevelledMobs.Companion.getInstance(), (Object)1));
            if (opts.getUseNoDrops()) {
                ((LivingEntity)entity).remove();
            } else {
                ((LivingEntity)entity).setHealth(0.0);
            }
            ++killed;
        }
        String[] stringArray = new String[]{"%killed%", "%skipped%", "%radius%"};
        String[] stringArray2 = stringArray;
        stringArray = new String[]{String.valueOf(killed), String.valueOf(skipped), String.valueOf(radius)};
        MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.kill.near.success", stringArray2, stringArray);
    }

    private final List<String> buildTabSuggestions(SuggestionInfo<CommandSender> info) {
        String string = info.currentInput();
        Intrinsics.checkNotNullExpressionValue(string, "currentInput(...)");
        List<String> args2 = Utils.INSTANCE.splitStringWithQuotes(string);
        String string2 = info.previousArgs().fullInput();
        Intrinsics.checkNotNullExpressionValue(string2, "fullInput(...)");
        List<String> prevArgs = Utils.INSTANCE.splitStringWithQuotes(string2);
        String lastArg = CollectionsKt.last(prevArgs);
        boolean containsNoDrops = false;
        boolean containsLevels = false;
        boolean containsWorld = false;
        if (StringsKt.equals("/levels", lastArg, true)) {
            return Utils.INSTANCE.getOneToNine();
        }
        int n = args2.size();
        for (int i = 3; i < n; ++i) {
            String arg = args2.get(i);
            if (StringsKt.equals("/nodrops", arg, true)) {
                containsNoDrops = true;
                continue;
            }
            if (StringsKt.equals("/levels", arg, true)) {
                containsLevels = true;
                continue;
            }
            if (StringsKt.startsWith$default(arg, "/", false, 2, null) || Utils.INSTANCE.isInteger(arg)) continue;
            containsWorld = true;
        }
        if (StringsKt.equals("all", args2.get(2), true) && args2.size() <= 7) {
            List worlds = new ArrayList();
            if (!containsNoDrops) {
                worlds.add("/nodrops");
            }
            if (!containsLevels) {
                worlds.add("/levels");
            }
            if (!containsWorld) {
                for (World world : Bukkit.getWorlds()) {
                    worlds.add("*");
                    if (!LevelledMobs.Companion.getInstance().getRulesManager().getRuleIsWorldAllowedInAnyRule(world)) continue;
                    String string3 = world.getName();
                    Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                    worlds.add(string3);
                }
            }
            return worlds;
        }
        if (StringsKt.equals("near", args2.get(2), true)) {
            if (args2.size() == 3) {
                return Utils.INSTANCE.getOneToNine();
            }
            if (StringsKt.equals("/levels", lastArg, true)) {
                String[] worlds = new String[]{"/levels"};
                return CollectionsKt.mutableListOf(worlds);
            }
        }
        List result = new ArrayList();
        if (!containsNoDrops) {
            result.add("/nodrops");
        }
        if (!containsLevels) {
            result.add("/levels");
        }
        return result;
    }

    private final RequestedLevel getLevelFromCommand(CommandSender sender, List<String> args2) {
        int rangeSpecifiedFlag = -1;
        int n = ((Collection)args2).size();
        for (int i = 0; i < n; ++i) {
            if (!StringsKt.equals("/levels", args2.get(i), true)) continue;
            rangeSpecifiedFlag = i + 1;
        }
        if (rangeSpecifiedFlag <= 0) {
            return null;
        }
        RequestedLevel rl = new RequestedLevel();
        if (args2.size() <= rangeSpecifiedFlag) {
            sender.sendMessage("No value was specified for /levels");
            rl.setHadInvalidArguments(true);
            return rl;
        }
        String value = args2.get(rangeSpecifiedFlag);
        if (!rl.setLevelFromString(value)) {
            sender.sendMessage("Invalid number or range specified for /levels");
            rl.setHadInvalidArguments(true);
        }
        return rl;
    }

    private final void processKillAll(CommandSender sender, List<World> worlds, boolean useNoDrops, RequestedLevel rl) {
        LevelledMobs.Companion.getInstance().getMobsQueueManager().clearQueue();
        int killed = 0;
        int skipped = 0;
        for (World world : worlds) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof LivingEntity) || !LevelledMobs.Companion.getInstance().getLevelInterface().isLevelled((LivingEntity)entity)) continue;
                if (this.skipKillingEntity((LivingEntity)entity, rl)) {
                    ++skipped;
                    continue;
                }
                ((LivingEntity)entity).setMetadata("noCommands", (MetadataValue)new FixedMetadataValue((Plugin)LevelledMobs.Companion.getInstance(), (Object)1));
                if (useNoDrops) {
                    ((LivingEntity)entity).remove();
                } else {
                    ((LivingEntity)entity).setHealth(0.0);
                }
                ++killed;
            }
        }
        String[] stringArray = new String[]{"%killed%", "%skipped%", "%worlds%"};
        String[] stringArray2 = stringArray;
        stringArray = new String[]{String.valueOf(killed), String.valueOf(skipped), String.valueOf(worlds.size())};
        MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.kill.all.success", stringArray2, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean skipKillingEntity(LivingEntity livingEntity, RequestedLevel rl) {
        int mobLevel;
        KillSkipConditions skc = MainCompanion.Companion.getInstance().getKillSkipConditions();
        if (livingEntity.getCustomName() != null && skc.isNametagged()) {
            return true;
        }
        if (rl != null && ((mobLevel = LevelledMobs.Companion.getInstance().getLevelInterface().getLevelOfMob(livingEntity)) < rl.getLevelMin() || mobLevel > rl.getLevelMax())) {
            return true;
        }
        if (livingEntity instanceof Tameable && skc.isTamed()) {
            return true;
        }
        if (livingEntity.isLeashed() && skc.isLeashed()) {
            return true;
        }
        if (livingEntity instanceof AbstractVillager && skc.isVillager()) {
            return true;
        }
        if (skc.getEntityTypes() != null) {
            CachedModalList<String> cachedModalList = skc.getEntityTypes();
            Intrinsics.checkNotNull(cachedModalList);
            if (!cachedModalList.isEmpty()) {
                CachedModalList<String> cachedModalList2 = skc.getEntityTypes();
                Intrinsics.checkNotNull(cachedModalList2);
                CachedModalList<String> et = cachedModalList2;
                if (et.getIncludeAll()) {
                    return false;
                }
                if (et.getExcludeAll()) {
                    return true;
                }
                LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
                try {
                    if (et.isIncludedInList(lmEntity.getNameIfBaby(), lmEntity) || et.getIncludedList().contains("baby_") && lmEntity.isBabyMob()) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    lmEntity.free();
                }
            }
        }
        return skc.isTransforming() && this.isMobConverting(livingEntity);
    }

    private final boolean isMobConverting(LivingEntity mob) {
        if (mob instanceof Hoglin && ((Hoglin)mob).isConverting()) {
            return true;
        }
        if (mob instanceof Husk && ((Husk)mob).isConverting()) {
            return true;
        }
        if (mob instanceof PiglinAbstract && ((PiglinAbstract)mob).isConverting()) {
            return true;
        }
        if (mob instanceof PigZombie && ((PigZombie)mob).isConverting()) {
            return true;
        }
        if (mob instanceof Skeleton && ((Skeleton)mob).isConverting()) {
            return true;
        }
        if (mob instanceof Zombie && ((Zombie)mob).isConverting()) {
            return true;
        }
        return mob instanceof ZombieVillager && ((ZombieVillager)mob).isConverting();
    }

    private static final void createInstance$lambda$0(CommandSender sender, CommandArguments commandArguments) {
        Intrinsics.checkNotNull(sender);
        MessagesHelper.INSTANCE.showMessage(sender, "levelledmobs.command.kill.usage");
    }

    private static final void createInstance$lambda$1(CommandSender sender, CommandArguments args2) {
        Intrinsics.checkNotNull(sender);
        Intrinsics.checkNotNull(args2);
        INSTANCE.processCmd(sender, args2, true);
    }

    private static final Collection createInstance$lambda$2(SuggestionInfo info) {
        Intrinsics.checkNotNull(info);
        return INSTANCE.buildTabSuggestions(info);
    }

    private static final void createInstance$lambda$3(CommandSender sender, CommandArguments args2) {
        Intrinsics.checkNotNull(sender);
        Intrinsics.checkNotNull(args2);
        INSTANCE.processCmd(sender, args2, false);
    }

    private static final Collection createInstance$lambda$4(SuggestionInfo info) {
        Intrinsics.checkNotNull(info);
        return INSTANCE.buildTabSuggestions(info);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/KillSubcommand$Options;", "", "args", "", "", "useNoDrops", "", "requestedLevel", "Lio/github/arcaneplugins/levelledmobs/misc/RequestedLevel;", "<init>", "(Ljava/util/List;ZLio/github/arcaneplugins/levelledmobs/misc/RequestedLevel;)V", "getArgs", "()Ljava/util/List;", "getUseNoDrops", "()Z", "getRequestedLevel", "()Lio/github/arcaneplugins/levelledmobs/misc/RequestedLevel;", "levelledmobs-plugin"})
    private static final class Options {
        @NotNull
        private final List<String> args;
        private final boolean useNoDrops;
        @Nullable
        private final RequestedLevel requestedLevel;

        public Options(@NotNull List<String> args2, boolean useNoDrops, @Nullable RequestedLevel requestedLevel) {
            Intrinsics.checkNotNullParameter(args2, "args");
            this.args = args2;
            this.useNoDrops = useNoDrops;
            this.requestedLevel = requestedLevel;
        }

        @NotNull
        public final List<String> getArgs() {
            return this.args;
        }

        public final boolean getUseNoDrops() {
            return this.useNoDrops;
        }

        @Nullable
        public final RequestedLevel getRequestedLevel() {
            return this.requestedLevel;
        }
    }
}

