/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.commands.LevelledMobsCommand;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.CommandFallback;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.CommandAPI;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.CommandAPIBukkitConfig;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.CommandAPICommand;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.exceptions.UnsupportedVersionException;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.util.Log;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\rH\u0002J\b\u0010\u0012\u001a\u00020\rH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/CommandHandler;", "", "<init>", "()V", "COMMANDS", "", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/CommandAPICommand;", "value", "", "hadErrorLoading", "getHadErrorLoading", "()Z", "load", "", "loadingStage", "Lio/github/arcaneplugins/levelledmobs/commands/CommandHandler$LoadingStage;", "loadFallbackCommands", "registerCommands", "unregisterCommands", "LoadingStage", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nCommandHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandHandler.kt\nio/github/arcaneplugins/levelledmobs/commands/CommandHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1863#2,2:96\n1863#2,2:98\n*S KotlinDebug\n*F\n+ 1 CommandHandler.kt\nio/github/arcaneplugins/levelledmobs/commands/CommandHandler\n*L\n82#1:96,2\n86#1:98,2\n*E\n"})
public final class CommandHandler {
    @NotNull
    public static final CommandHandler INSTANCE = new CommandHandler();
    @NotNull
    private static final List<CommandAPICommand> COMMANDS = new ArrayList();
    private static boolean hadErrorLoading;

    private CommandHandler() {
    }

    public final boolean getHadErrorLoading() {
        return hadErrorLoading;
    }

    public final void load(@NotNull LoadingStage loadingStage) {
        Intrinsics.checkNotNullParameter((Object)loadingStage, "loadingStage");
        switch (WhenMappings.$EnumSwitchMapping$0[loadingStage.ordinal()]) {
            case 1: {
                try {
                    Log.INSTANCE.inf("Loading commands");
                    CommandAPIBukkitConfig commandCfg = (CommandAPIBukkitConfig)((CommandAPIBukkitConfig)new CommandAPIBukkitConfig(LevelledMobs.Companion.getInstance()).silentLogs(true)).verboseOutput(false);
                    CommandAPI.onLoad(commandCfg);
                    this.registerCommands();
                    break;
                }
                catch (UnsupportedVersionException e) {
                    hadErrorLoading = true;
                    String string = e.getMessage();
                    Intrinsics.checkNotNull(string);
                    Log.INSTANCE.sev(string);
                    Log.INSTANCE.war("The plugin may continue to work with limited commands. Please see if an updated version of LevelledMobs is available.");
                    this.loadFallbackCommands();
                    break;
                }
                catch (Exception e) {
                    hadErrorLoading = true;
                    this.loadFallbackCommands();
                    throw e;
                }
            }
            case 2: {
                if (hadErrorLoading) break;
                Log.INSTANCE.inf("Enabling commands");
                CommandAPI.onEnable();
                break;
            }
            case 3: {
                if (hadErrorLoading) break;
                Log.INSTANCE.inf("Unregistering commands");
                this.unregisterCommands();
                break;
            }
            case 4: {
                if (hadErrorLoading) break;
                Log.INSTANCE.inf("Manually registering commands");
                this.registerCommands();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void loadFallbackCommands() {
        CommandFallback fallbackCommands = new CommandFallback("levelledmobs");
        String[] stringArray = new String[]{"levelledmobs", "lm", "lvlmobs", "leveledmobs"};
        List<String> aliases = CollectionsKt.mutableListOf(stringArray);
        Field fieldCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
        fieldCommandMap.trySetAccessible();
        Object object = fieldCommandMap.get(Bukkit.getServer());
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bukkit.command.CommandMap");
        CommandMap commandMap = (CommandMap)object;
        for (String alias : aliases) {
            commandMap.register(alias, LevelledMobs.Companion.getInstance().getName(), (Command)fallbackCommands);
        }
    }

    private final void registerCommands() {
        COMMANDS.clear();
        COMMANDS.add(LevelledMobsCommand.INSTANCE.createInstance());
        Iterable $this$forEach$iv = COMMANDS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommandAPICommand cmd = (CommandAPICommand)element$iv;
            boolean bl = false;
            cmd.register();
        }
    }

    private final void unregisterCommands() {
        Iterable $this$forEach$iv = COMMANDS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommandAPICommand cmd = (CommandAPICommand)element$iv;
            boolean bl = false;
            CommandAPI.unregister(cmd.getName());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/CommandHandler$LoadingStage;", "", "<init>", "(Ljava/lang/String;I)V", "ON_LOAD", "ON_ENABLE", "ON_DISABLE", "FORCED", "levelledmobs-plugin"})
    public static final class LoadingStage
    extends Enum<LoadingStage> {
        public static final /* enum */ LoadingStage ON_LOAD = new LoadingStage();
        public static final /* enum */ LoadingStage ON_ENABLE = new LoadingStage();
        public static final /* enum */ LoadingStage ON_DISABLE = new LoadingStage();
        public static final /* enum */ LoadingStage FORCED = new LoadingStage();
        private static final /* synthetic */ LoadingStage[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LoadingStage[] values() {
            return (LoadingStage[])$VALUES.clone();
        }

        public static LoadingStage valueOf(String value) {
            return Enum.valueOf(LoadingStage.class, value);
        }

        @NotNull
        public static EnumEntries<LoadingStage> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = loadingStageArray = new LoadingStage[]{LoadingStage.ON_LOAD, LoadingStage.ON_ENABLE, LoadingStage.ON_DISABLE, LoadingStage.FORCED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoadingStage.values().length];
            try {
                nArray[LoadingStage.ON_LOAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadingStage.ON_ENABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadingStage.ON_DISABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadingStage.FORCED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

