/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot.lazies;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ListenerAutoRegistration {
    final JavaPlugin plugin;
    final boolean loadDevListeners;

    public ListenerAutoRegistration(JavaPlugin plugin, boolean loadDevListeners) {
        this.plugin = plugin;
        this.loadDevListeners = loadDevListeners;
    }

    public void register(String packageName) {
        this.register(packageName, true);
    }

    public void register(String packageName, boolean deep) {
        ClassPath classPath;
        ClassLoader classLoader = this.plugin.getClass().getClassLoader();
        try {
            classPath = ClassPath.from((ClassLoader)classLoader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (ClassPath.ClassInfo classInfo : deep ? classPath.getTopLevelClassesRecursive(packageName) : classPath.getTopLevelClasses(packageName)) {
            try {
                Object[] objectArray;
                boolean devListener;
                Class<?> clazz = classLoader.loadClass(classInfo.getName());
                if (!Listener.class.isAssignableFrom(clazz) || (devListener = clazz.isAnnotationPresent(DevServerListener.class)) && !this.loadDevListeners) continue;
                Constructor<?> constructor = clazz.getConstructors()[0];
                if (constructor.getParameterCount() == 0) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = this.plugin;
                }
                Listener instance = (Listener)constructor.newInstance(objectArray);
                Bukkit.getPluginManager().registerEvents(instance, (Plugin)this.plugin);
                this.plugin.getLogger().info("Loaded " + (devListener ? "dev" : "") + " listener " + clazz.getSimpleName() + "!");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DevServerListener {
    }
}

