/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot.inventory;

import net.apartium.cocoabeans.spigot.ServerUtils;
import net.apartium.cocoabeans.spigot.inventory.ItemFactory;
import net.apartium.cocoabeans.structs.MinecraftVersion;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class ItemFactoryInstantiator {
    ItemFactoryInstantiator() {
    }

    static ItemFactory create() {
        MinecraftVersion minecraftVersion = ServerUtils.getVersion();
        return switch (minecraftVersion.update()) {
            case 8 -> ItemFactoryInstantiator.constructImpl("ItemFactory_1_8_R1");
            default -> ItemFactoryInstantiator.constructImpl("ItemFactory_1_20_R1");
        };
    }

    private static ItemFactory constructImpl(String clazz) {
        return ItemFactoryInstantiator.construct(clazz, ItemFactory.class);
    }

    static <T> T construct(String name, Class<T> type) {
        try {
            Class<T> cls = Class.forName(String.format("net.apartium.cocoabeans.spigot.inventory.%s", name), true, ItemFactory.class.getClassLoader()).asSubclass(type);
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

