/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot.inventory;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.collect.Multimap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.apartium.cocoabeans.spigot.inventory.EnchantGlow;
import net.apartium.cocoabeans.spigot.inventory.InventoryNMSUtils;
import net.apartium.cocoabeans.spigot.inventory.ItemFactory;
import net.apartium.cocoabeans.spigot.inventory.ItemFactoryInstantiator;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Blocking;

public abstract class ItemBuilder {
    private static final ItemFactory factory = ItemFactoryInstantiator.create();
    ItemStack item;
    ItemMeta meta;

    public static ItemBuilder builder(ItemStack itemStack) {
        return factory.builder(itemStack);
    }

    public static ItemBuilder builder(Material material) {
        return factory.builder(material);
    }

    @Blocking
    public static ItemBuilder skullBuilder(OfflinePlayer offlinePlayer) {
        return factory.skullBuilder(offlinePlayer);
    }

    public static ItemBuilder skullBuilder(PlayerProfile playerProfile) {
        return factory.skullBuilder(playerProfile);
    }

    public static ItemBuilder skullBuilder(URL url) {
        return factory.skullBuilder(url);
    }

    public static ItemBuilder skullBuilder(String base64) {
        return factory.skullBuilder(base64);
    }

    @ApiStatus.Internal
    ItemBuilder(ItemStack item) {
        this.item = item.clone();
        this.meta = item.getItemMeta();
    }

    public ItemBuilder setSkullTextureBase64(String base64) throws MalformedURLException {
        ItemMeta itemMeta = this.meta;
        if (!(itemMeta instanceof SkullMeta)) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        String decodeText = new String(Base64.getDecoder().decode(base64));
        int start = decodeText.indexOf("http");
        int end = decodeText.indexOf("\"}}}");
        if (start == -1 || end == -1) {
            return this;
        }
        this.setSkullTextureURL(new URL(decodeText.substring(start, end)));
        return this;
    }

    @Blocking
    public abstract ItemBuilder setOwningPlayer(OfflinePlayer var1);

    public ItemBuilder setSkullProfile(PlayerProfile profile) {
        ItemMeta itemMeta = this.meta;
        if (!(itemMeta instanceof SkullMeta)) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        skullMeta.setPlayerProfile(profile);
        return this;
    }

    public ItemBuilder setSkullTextureURL(URL url) {
        ItemMeta itemMeta = this.meta;
        if (!(itemMeta instanceof SkullMeta)) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        org.bukkit.profile.PlayerProfile playerProfile = Bukkit.getServer().createPlayerProfile(UUID.randomUUID(), null);
        playerProfile.getTextures().setSkin(url);
        skullMeta.setOwnerProfile(playerProfile);
        return this;
    }

    public ItemBuilder setLore(String ... texts) {
        if (texts == null || texts.length == 0) {
            this.meta.setLore(List.of());
            return this;
        }
        this.meta.setLore(Arrays.asList(texts));
        return this;
    }

    public ItemBuilder setLore(List<Component> lore) {
        this.meta.lore(lore);
        return this;
    }

    public ItemBuilder setLoreAsText(List<String> lore) {
        this.meta.setLore(lore);
        return this;
    }

    public abstract ItemBuilder setDurability(short var1);

    public ItemBuilder setDisplayName(Component component) {
        this.meta.displayName(component);
        return this;
    }

    public ItemBuilder setDisplayName(String name) {
        this.meta.setDisplayName(name);
        return this;
    }

    public ItemBuilder setNBT(NamespacedKey namespacedKey, Object persistentDataType, Object object) {
        this.meta.getPersistentDataContainer().set(namespacedKey, (PersistentDataType)persistentDataType, object);
        return this;
    }

    public ItemBuilder setAttributeModifiers(Multimap<Attribute, AttributeModifier> map) {
        this.meta.setAttributeModifiers(map);
        return this;
    }

    public ItemBuilder addAttributeModifiers(Attribute attribute, AttributeModifier attributeModifier) {
        this.meta.addAttributeModifier(attribute, attributeModifier);
        return this;
    }

    public ItemBuilder setAmount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder addLine(String ... lines) {
        if (this.meta.getLore() == null) {
            this.meta.setLore(Arrays.asList(lines));
        }
        this.meta.getLore().addAll(List.of(lines));
        return this;
    }

    public ItemBuilder removeLine(String text) {
        if (this.meta.getLore() != null) {
            this.meta.getLore().remove(text);
        }
        return this;
    }

    public ItemBuilder removeLine(int index) {
        if (this.meta.getLore() == null) {
            return this;
        }
        if (index < 0) {
            return this;
        }
        if (this.meta.getLore().size() >= index) {
            return this;
        }
        this.meta.getLore().remove(index);
        return this;
    }

    public ItemBuilder setCustomModelData(int data) {
        this.meta.setCustomModelData(Integer.valueOf(data));
        return this;
    }

    public ItemBuilder setColor(Color color) {
        Object object = this.meta;
        if (object instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)object;
            leatherArmorMeta.setColor(color);
            return this;
        }
        object = this.meta;
        if (object instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)object;
            potionMeta.setColor(color);
            return this;
        }
        object = this.meta;
        if (object instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)object;
            for (FireworkEffect fireworkEffect : fireworkMeta.getEffects()) {
                fireworkEffect.getColors().clear();
                fireworkEffect.getColors().add(color);
                fireworkEffect.getFadeColors().clear();
                fireworkEffect.getFadeColors().add(color);
            }
            return this;
        }
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int level) {
        ItemMeta itemMeta = this.meta;
        if (itemMeta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
            enchantmentStorageMeta.addStoredEnchant(enchantment, level, true);
            return this;
        }
        this.meta.addEnchant(enchantment, level, true);
        return this;
    }

    public ItemBuilder removeEnchantment(Enchantment enchantment) {
        this.meta.removeEnchant(enchantment);
        return this;
    }

    public ItemBuilder setEnchantment(Map<Enchantment, Integer> enchantments) {
        for (Enchantment enchantment : Enchantment.values()) {
            this.meta.removeEnchant(enchantment);
        }
        for (Map.Entry entry : enchantments.entrySet()) {
            this.addEnchantment((Enchantment)entry.getKey(), (Integer)entry.getValue());
        }
        return this;
    }

    public ItemBuilder setGlowing(boolean isGlowing) {
        if (isGlowing) {
            this.addEnchantment(EnchantGlow.ENCHANT_GLOW, 1);
        } else {
            this.removeEnchantment(EnchantGlow.ENCHANT_GLOW);
        }
        return this;
    }

    public ItemBuilder setType(Material material) {
        this.item.setType(material);
        this.meta = this.item.getItemMeta();
        return this;
    }

    public abstract ItemBuilder setUnbreakable(boolean var1);

    public ItemBuilder addItemFlags(ItemFlag ... itemFlags) {
        this.meta.addItemFlags(itemFlags);
        return this;
    }

    public ItemBuilder setPotionData(PotionData potionData) {
        ItemMeta itemMeta = this.meta;
        if (!(itemMeta instanceof PotionMeta)) {
            return this;
        }
        PotionMeta potionMeta = (PotionMeta)itemMeta;
        potionMeta.setBasePotionData(potionData);
        return this;
    }

    public ItemBuilder addPotionEffect(PotionEffect potionEffect) {
        ItemMeta itemMeta = this.meta;
        if (!(itemMeta instanceof PotionMeta)) {
            return this;
        }
        PotionMeta potionMeta = (PotionMeta)itemMeta;
        potionMeta.addCustomEffect(potionEffect, true);
        return this;
    }

    private ItemBuilder addNbtTagStringList(String key, String ... values) {
        this.item.setItemMeta(this.meta);
        try {
            Object stack = InventoryNMSUtils.getCraftItemStack_asNMSCopy().invoke(null, this.item);
            Object idsTag = InventoryNMSUtils.getNbtTagList_constructors().newInstance(new Object[0]);
            for (String id : values) {
                InventoryNMSUtils.getNbtTagList_add().invoke(idsTag, InventoryNMSUtils.getNbtTagString_aString().invoke(null, id));
            }
            Object tag = InventoryNMSUtils.getItemStack_u().invoke(stack, new Object[0]) != null ? InventoryNMSUtils.getItemStack_u().invoke(stack, new Object[0]) : InventoryNMSUtils.getNbtTagCompound_constructors().newInstance(new Object[0]);
            InventoryNMSUtils.getNbtTagString_a().invoke(tag, key, idsTag);
            InventoryNMSUtils.getItemStack_a().invoke(null, tag);
            this.item = (ItemStack)InventoryNMSUtils.getCraftItemStack_asBukkitCopy().invoke(null, stack);
        }
        catch (Exception e) {
            this.meta = this.item.getItemMeta();
            return this;
        }
        this.meta = this.item.getItemMeta();
        return this;
    }

    @ApiStatus.Experimental
    public ItemBuilder addCanDestroy(String ... ids) {
        this.addNbtTagStringList("CanDestroy", ids);
        return this;
    }

    @ApiStatus.Experimental
    public ItemBuilder addCanPlaceOn(String ... ids) {
        this.addNbtTagStringList("CanPlaceOn", ids);
        return this;
    }

    public ItemStack build() {
        this.item.setItemMeta(this.meta);
        return this.item.clone();
    }
}

