/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.apartium.cocoabeans.structs.MinecraftVersion;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class ServerUtils {
    public static final String VERSION_PATTERN = "\\d+(\\.\\d+)*";
    private static final MinecraftVersion version = ServerUtils.detectVersion();

    @NotNull
    public static MinecraftVersion getVersion() {
        return version;
    }

    private static MinecraftVersion detectVersion() {
        String version = ServerUtils.extractVersionNumber(Bukkit.getBukkitVersion());
        if (version == null) {
            return MinecraftVersion.UNKNOWN;
        }
        String[] split = version.split("\\.");
        return new MinecraftVersion(Integer.parseInt(split[0]), Integer.parseInt(split[1]), split.length == 2 ? 0 : Integer.parseInt(split[2]));
    }

    private static String extractVersionNumber(String versionString) {
        Matcher matcher = Pattern.compile(VERSION_PATTERN).matcher(versionString);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }
}

