/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot;

import java.util.HashSet;
import java.util.Set;
import net.apartium.cocoabeans.Ensures;
import net.apartium.cocoabeans.space.Position;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.ApiStatus;

public class Locations {
    public static boolean isSameWorld(Location loc1, Location loc2) {
        Ensures.notNull((Object)loc1, "loc1 +-");
        Ensures.notNull((Object)loc2, "loc2 +-");
        return loc1.getWorld().equals(loc2.getWorld());
    }

    public static Set<Location> getLocationsBetween(Location pos1, Location pos2) {
        int maxY;
        int maxZ;
        int maxX;
        Ensures.isTrue(Locations.isSameWorld(pos1, pos2), "pos1 and pos2 must be in the same world");
        HashSet<Location> set = new HashSet<Location>();
        World world = pos1.getWorld();
        if (pos1.getBlockX() > pos2.getBlockX()) {
            maxX = pos1.getBlockX();
            minX = pos2.getBlockX();
        } else {
            maxX = pos2.getBlockX();
            minX = pos1.getBlockX();
        }
        if (pos1.getBlockZ() > pos2.getBlockZ()) {
            maxZ = pos1.getBlockZ();
            minZ = pos2.getBlockZ();
        } else {
            maxZ = pos2.getBlockZ();
            minZ = pos1.getBlockZ();
        }
        if (pos1.getBlockY() > pos2.getBlockY()) {
            maxY = pos1.getBlockY();
            minY = pos2.getBlockY();
        } else {
            maxY = pos2.getBlockY();
            minY = pos1.getBlockY();
        }
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    set.add(new Location(world, (double)x, (double)y, (double)z));
                }
            }
        }
        return set;
    }

    @ApiStatus.AvailableSince(value="0.0.22")
    public static Position toPosition(Location location) {
        return new Position(location.getX(), location.getY(), location.getZ());
    }

    @ApiStatus.AvailableSince(value="0.0.22")
    public static Location toLocation(World world, Position position) {
        return new Location(world, position.getX(), position.getY(), position.getZ());
    }
}

