/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.45")
public class DNSLookup {
    private final InitialDirContext context;

    public static DNSLookup withDefaultOptions() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        try {
            return new DNSLookup(new InitialDirContext(env));
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public DNSLookup(InitialDirContext context) {
        this.context = context;
    }

    public String reverseLookup(InetAddress address) throws NamingException {
        if (address instanceof Inet4Address) {
            Inet4Address inet4Address = (Inet4Address)address;
            byte[] addressBytes = inet4Address.getAddress();
            String fqdn = String.format("%d.%d.%d.%d.in-addr.arpa", addressBytes[3] & 0xFF, addressBytes[2] & 0xFF, addressBytes[1] & 0xFF, addressBytes[0] & 0xFF);
            return this.lookup(fqdn, "PTR").get(0);
        }
        throw new IllegalArgumentException("Unsupported address type: " + String.valueOf(address.getClass()));
    }

    public List<String> lookup(String hostName, String recordType) throws NamingException {
        Attribute attr = this.context.getAttributes("dns:" + hostName, new String[]{recordType}).get(recordType);
        return Collections.list(attr.getAll());
    }
}

