/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.state.animation;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.state.Observer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.39")
public class TypingObservable
implements Observable<String>,
Observer {
    private final Set<Observer> observers = Collections.newSetFromMap(new WeakHashMap());
    private final Observable<String> textObservable;
    private final Observable<Long> animationLength;
    private final Observable<Long> textAnimationLength;
    private final Observable<Instant> nowObservable;
    private boolean dirty = true;
    private String cacheText = null;
    private String lastText = null;
    private long lastTick = -1L;
    private final long stayAtStart;
    private final long stayAtEnd;
    private final long writingSpeedPerCharacter;
    private final String prefix;

    public TypingObservable(Observable<String> textObservable, Observable<Instant> nowObservable, Duration stayAtStart, Duration stayAtEnd, Duration writingSpeedPerCharacter, String prefix) {
        this.textObservable = textObservable;
        this.nowObservable = nowObservable;
        this.stayAtStart = stayAtStart.toMillis();
        this.stayAtEnd = stayAtEnd.toMillis();
        this.writingSpeedPerCharacter = writingSpeedPerCharacter.toMillis();
        this.prefix = prefix;
        this.textAnimationLength = textObservable.map(text -> this.writingSpeedPerCharacter * (long)text.length());
        this.animationLength = this.textAnimationLength.map(textAnimationLength -> textAnimationLength * 2L + this.stayAtStart + this.stayAtEnd);
        this.textObservable.observe(this);
        this.nowObservable.observe(this);
    }

    @Override
    public String get() {
        if (!this.dirty) {
            return this.cacheText;
        }
        long animationLength = this.animationLength.get();
        long currentTick = this.nowObservable.get().toEpochMilli() % animationLength;
        String text = this.textObservable.get();
        if (currentTick == this.lastTick && Objects.equals(this.lastText, text)) {
            return this.cacheText;
        }
        this.dirty = false;
        this.lastTick = currentTick;
        this.lastText = text;
        long textAnimationLength = this.textAnimationLength.get();
        this.cacheText = currentTick <= this.stayAtStart ? "" : (textAnimationLength + this.stayAtStart <= currentTick && currentTick <= textAnimationLength + this.stayAtStart + this.stayAtEnd ? text : (currentTick >= this.stayAtStart + this.stayAtEnd + textAnimationLength ? this.typeByIndex(text, (int)((long)(text.length() - 1) - (currentTick - this.stayAtStart - this.stayAtEnd - textAnimationLength) / this.writingSpeedPerCharacter)) : this.typeByIndex(text, (int)((currentTick - this.stayAtStart) / this.writingSpeedPerCharacter))));
        return this.cacheText;
    }

    private String typeByIndex(String text, int index) {
        if (index == 0) {
            return this.prefix + text.charAt(0);
        }
        if (index == text.length() - 1) {
            return text.substring(0, text.length() - 1) + this.prefix + text.charAt(text.length() - 1);
        }
        return text.substring(0, index) + this.prefix + text.charAt(index);
    }

    @Override
    public void observe(Observer observer) {
        this.observers.add(observer);
    }

    @Override
    public boolean removeObserver(Observer observer) {
        return this.observers.remove(observer);
    }

    @Override
    public void flagAsDirty(Observable<?> observable) {
        if (this.textObservable != observable && this.nowObservable != observable) {
            return;
        }
        this.dirty = true;
        for (Observer observer : this.observers) {
            observer.flagAsDirty(this);
        }
    }
}

