/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.state.animation;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.apartium.cocoabeans.Mathf;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.state.Observer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.39")
public class FixedDoubleLerpObservable
implements Observable<Double>,
Observer {
    private final Observable<Double> source;
    private final Observable<Instant> nowObservable;
    private final Set<Observer> observers = Collections.newSetFromMap(new WeakHashMap());
    private final Duration duration;
    private Instant startInstant = null;
    private double self;
    private double last;
    private double start;
    private boolean dirty = false;

    public FixedDoubleLerpObservable(Observable<Double> source, Observable<Instant> nowObservable, Duration duration) {
        this.source = source;
        this.nowObservable = nowObservable;
        this.start = this.last = this.source.get().doubleValue();
        this.self = this.last;
        this.duration = duration;
        this.source.observe(this);
        this.nowObservable.observe(this);
    }

    @Override
    public Double get() {
        double current = this.source.get();
        if (this.start != current) {
            this.startInstant = this.nowObservable.get();
            this.dirty = true;
            this.start = current;
            this.last = this.self;
        }
        if (current == this.self) {
            this.dirty = false;
            this.last = this.self;
            return this.self;
        }
        this.dirty = true;
        this.self = Mathf.lerp(this.last, current, Math.min(1.0, Math.max(0.0, (double)Duration.between(this.startInstant, this.nowObservable.get()).toMillis() / (double)this.duration.toMillis())));
        return this.self;
    }

    @Override
    public void observe(Observer observer) {
        this.observers.add(observer);
    }

    @Override
    public boolean removeObserver(Observer observer) {
        return this.observers.remove(observer);
    }

    @Override
    public void flagAsDirty(Observable<?> observable) {
        if (this.dirty && this.nowObservable == observable) {
            for (Observer observer : this.observers) {
                observer.flagAsDirty(this);
            }
            return;
        }
        if (this.source != observable) {
            return;
        }
        for (Observer observer : this.observers) {
            observer.flagAsDirty(this);
        }
    }
}

