/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.state.animation;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.state.Observer;
import net.apartium.cocoabeans.state.animation.AnimationHelpers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.39")
public class FadingColorInOutObservable
implements Observable<Component>,
Observer {
    private final Set<Observer> observers = Collections.newSetFromMap(new WeakHashMap());
    private final Observable<String> textObservable;
    private final Observable<Instant> nowObservable;
    private final long stayAtStart;
    private final long stayAtEnd;
    private final long characterDelay;
    private final Style in;
    private final Style fade;
    private final Style out;
    private final Observable<Long> textAnimationLength;
    private final Observable<Long> animationLength;
    private boolean dirty = true;
    private Component cacheText = null;
    private String lastText = null;
    private long lastTick = -1L;

    public FadingColorInOutObservable(Observable<String> textObservable, Observable<Instant> nowObservable, Duration stayAtStart, Duration stayAtEnd, Duration characterDelay, Style in, Style fade, Style out) {
        this.textObservable = textObservable;
        this.nowObservable = nowObservable;
        this.stayAtStart = stayAtStart.toMillis();
        this.stayAtEnd = stayAtEnd.toMillis();
        this.characterDelay = characterDelay.toMillis();
        this.in = in;
        this.fade = fade;
        this.out = out;
        this.textAnimationLength = textObservable.map(text -> (long)text.length() * this.characterDelay);
        this.animationLength = this.textAnimationLength.map(textLength -> textLength * 2L + this.stayAtStart + this.stayAtEnd);
        this.textObservable.observe(this);
        this.nowObservable.observe(this);
    }

    @Override
    public Component get() {
        if (!this.dirty) {
            return this.cacheText;
        }
        long animationLength = this.animationLength.get();
        long currentTick = this.nowObservable.get().toEpochMilli() % animationLength;
        String text = this.textObservable.get();
        if (currentTick == this.lastTick && Objects.equals(this.lastText, text)) {
            return this.cacheText;
        }
        this.dirty = false;
        this.lastTick = currentTick;
        this.lastText = text;
        long textAnimationLength = this.textAnimationLength.get();
        if (currentTick <= this.stayAtStart) {
            this.cacheText = Component.text((String)text).style(this.in);
        } else if (textAnimationLength + this.stayAtStart <= currentTick && currentTick <= textAnimationLength + this.stayAtStart + this.stayAtEnd) {
            this.cacheText = Component.text((String)text).style(this.out);
        } else if (currentTick >= textAnimationLength + this.stayAtStart + this.stayAtEnd) {
            int index = text.length() - 1 - (int)((currentTick - this.stayAtStart - this.stayAtEnd - textAnimationLength) / this.characterDelay);
            this.cacheText = this.fadeByIndex(text, index);
        } else {
            int index = (int)((currentTick - this.stayAtStart) / this.characterDelay);
            this.cacheText = this.fadeByIndex(text, index);
        }
        return this.cacheText;
    }

    private Component fadeByIndex(String text, int index) {
        return AnimationHelpers.fading(text, index, this.fade, this.in, this.out);
    }

    @Override
    public void observe(Observer observer) {
        this.observers.add(observer);
    }

    @Override
    public boolean removeObserver(Observer observer) {
        return this.observers.remove(observer);
    }

    @Override
    public void flagAsDirty(Observable<?> observable) {
        if (this.textObservable != observable && this.nowObservable != observable) {
            return;
        }
        this.dirty = true;
        for (Observer observer : this.observers) {
            observer.flagAsDirty(this);
        }
    }
}

