/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.state;

import java.util.Objects;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.state.Observer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.39")
public abstract class Watcher<T>
implements Observer {
    protected final Observable<T> depends;
    private boolean first = true;
    private boolean isDirty = true;
    private T prevValue;

    public Watcher(Observable<T> depends) {
        depends.observe(this);
        this.depends = depends;
    }

    public void heartbeat() {
        if (!this.isDirty) {
            return;
        }
        T value = this.depends.get();
        if (Objects.equals(value, this.prevValue) && !this.first) {
            return;
        }
        this.prevValue = value;
        this.first = false;
        this.isDirty = false;
        this.onChange(value);
    }

    @ApiStatus.AvailableSince(value="0.0.41")
    public abstract void onChange(T var1);

    public void detach() {
        this.depends.removeObserver(this);
    }

    @Override
    public void flagAsDirty(Observable<?> observable) {
        this.isDirty = true;
    }
}

