/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.state;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import net.apartium.cocoabeans.state.MutableObservable;
import net.apartium.cocoabeans.state.Observer;

class MutableObservableImpl<T>
implements MutableObservable<T> {
    private T value;
    private final Set<Observer> observers = Collections.newSetFromMap(new WeakHashMap());

    MutableObservableImpl(T value) {
        this.value = value;
    }

    @Override
    public void set(T value) {
        if (Objects.equals(this.value, value)) {
            return;
        }
        this.value = value;
        for (Observer observer : this.observers) {
            observer.flagAsDirty(this);
        }
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void observe(Observer observer) {
        this.observers.add(observer);
    }

    @Override
    public boolean removeObserver(Observer observer) {
        return this.observers.remove(observer);
    }
}

