/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.state;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.apartium.cocoabeans.CollectionHelpers;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.state.Observer;

class MappedObservable<F, T>
implements Observable<T>,
Observer {
    private final Observable<F> base;
    private F prev;
    private boolean isDirty;
    private boolean first = true;
    private T value;
    private final Function<F, T> mapper;
    private final Set<Observer> observers = Collections.newSetFromMap(new WeakHashMap());

    public MappedObservable(Observable<F> base, Function<F, T> mapper) {
        this.base = base;
        this.mapper = mapper;
    }

    @Override
    public T get() {
        boolean hadChange;
        if (!this.isDirty && !this.first) {
            return this.value;
        }
        F parameter = this.base.get();
        boolean bl = hadChange = !Objects.equals(parameter, this.prev);
        if (parameter instanceof Collection) {
            Collection a = (Collection)parameter;
            Object object = this.prev;
            if (object instanceof Collection) {
                Collection b = (Collection)object;
                boolean bl2 = hadChange = !CollectionHelpers.equalsCollections(a, b);
            }
        }
        if (!this.first && !hadChange) {
            this.isDirty = false;
            return this.value;
        }
        this.prev = parameter;
        this.first = false;
        this.isDirty = false;
        T temp = this.mapper.apply(parameter);
        boolean hasChange = !Objects.equals(temp, this.value);
        this.value = temp;
        if (hasChange) {
            for (Observer observer : this.observers) {
                observer.flagAsDirty(this);
            }
        }
        return this.value;
    }

    @Override
    public void observe(Observer observer) {
        this.observers.add(observer);
    }

    @Override
    public boolean removeObserver(Observer observer) {
        return this.observers.remove(observer);
    }

    @Override
    public void flagAsDirty(Observable<?> observable) {
        if (observable != this.base) {
            return;
        }
        this.isDirty = true;
        for (Observer observer : this.observers) {
            observer.flagAsDirty(this);
        }
    }
}

