/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.state;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.apartium.cocoabeans.CollectionHelpers;
import net.apartium.cocoabeans.state.AbstractCollectionObservable;
import net.apartium.cocoabeans.state.ListObservable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class ListObservableImpl<E>
extends AbstractCollectionObservable<E, List<E>>
implements ListObservable<E> {
    public ListObservableImpl() {
        this(new ArrayList());
    }

    public ListObservableImpl(List<E> list) {
        super(list);
    }

    @Override
    public void add(int index, E element) {
        int prevSize = ((List)this.collection).size();
        ((List)this.collection).add(index, element);
        if (prevSize == ((List)this.collection).size()) {
            return;
        }
        this.notifyObservers();
    }

    @Override
    public E remove(int index) {
        Object element = ((List)this.collection).remove(index);
        if (element == null) {
            return null;
        }
        this.notifyObservers();
        return element;
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        if (CollectionHelpers.isSorted((List)this.collection, comparator)) {
            return;
        }
        ((List)this.collection).sort(comparator);
        this.notifyObservers();
    }

    @Override
    public List<E> get() {
        return List.copyOf(this.collection);
    }
}

