/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot.tab;

import java.util.Optional;
import java.util.Set;
import net.apartium.cocoabeans.scoreboard.ViewerGroup;
import net.apartium.cocoabeans.tab.TabList;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.AvailableSince(value="0.0.41")
public class SpigotTabList
extends TabList<Player> {
    private final boolean hasNativeKyori;

    @VisibleForTesting
    SpigotTabList(ViewerGroup<Player> group, boolean hasNativeKyori) {
        super(group);
        this.hasNativeKyori = hasNativeKyori;
    }

    public SpigotTabList(ViewerGroup<Player> group) {
        this(group, Audience.class.isAssignableFrom(Player.class));
    }

    @Override
    protected void sendPlayerListHeaderAndFooter(Set<Player> viewers, Component header, Component footer) {
        if (viewers.isEmpty()) {
            return;
        }
        if (this.hasNativeKyori) {
            ForwardingAudience audience = Audience.audience(viewers);
            audience.sendPlayerListHeaderAndFooter(header, footer);
        } else {
            BungeeComponentSerializer serializer = BungeeComponentSerializer.get();
            BaseComponent[] baseHeader = Optional.ofNullable(header).map(arg_0 -> ((BungeeComponentSerializer)serializer).serialize(arg_0)).orElse(new BaseComponent[0]);
            BaseComponent[] baseFooter = Optional.ofNullable(footer).map(arg_0 -> ((BungeeComponentSerializer)serializer).serialize(arg_0)).orElse(new BaseComponent[0]);
            for (Player player : viewers) {
                player.setPlayerListHeaderFooter(baseHeader, baseFooter);
            }
        }
    }

    @VisibleForTesting
    boolean hasNativeKyori() {
        return this.hasNativeKyori;
    }
}

