/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.space;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.30")
public class Rotation {
    private float yaw;
    private float pitch;

    @JsonCreator
    public Rotation(@JsonProperty(value="yaw") float yaw, @JsonProperty(value="pitch") float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public Rotation(Rotation other) {
        this.yaw = other.yaw;
        this.pitch = other.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public Rotation setYaw(float yaw) {
        this.yaw = yaw;
        return this;
    }

    public float getPitch() {
        return this.pitch;
    }

    public Rotation setPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public Rotation add(Rotation other) {
        this.yaw += other.yaw;
        this.pitch += other.pitch;
        return this;
    }

    public Rotation subtract(Rotation other) {
        this.yaw -= other.yaw;
        this.pitch -= other.pitch;
        return this;
    }

    public Rotation multiply(double scalar) {
        this.yaw = (float)((double)this.yaw * scalar);
        this.pitch = (float)((double)this.pitch * scalar);
        return this;
    }

    public Rotation normalize() {
        this.yaw = (this.yaw % 360.0f + 360.0f) % 360.0f;
        this.pitch = Math.max(-90.0f, Math.min(90.0f, this.pitch));
        return this;
    }

    public double dot(Rotation other) {
        return this.yaw * other.yaw + this.pitch * other.pitch;
    }

    public double magnitude() {
        return Math.sqrt(this.yaw * this.yaw + this.pitch * this.pitch);
    }

    public String toString() {
        return "Rotation(yaw=" + this.yaw + ", pitch=" + this.pitch + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rotation rotation = (Rotation)o;
        return Float.compare(this.yaw, rotation.yaw) == 0 && Float.compare(this.pitch, rotation.pitch) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.yaw), Float.valueOf(this.pitch));
    }
}

