/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.space;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import net.apartium.cocoabeans.space.ImmutablePosition;
import net.apartium.cocoabeans.space.Rotation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.22")
public class Position {
    public static final Position ZERO = new ImmutablePosition(0.0, 0.0, 0.0);
    public static final Position UP = new ImmutablePosition(0.0, 1.0, 0.0);
    public static final Position DOWN = new ImmutablePosition(0.0, -1.0, 0.0);
    private double x;
    private double y;
    private double z;

    @JsonCreator
    @ApiStatus.AvailableSince(value="0.0.30")
    public Position(@JsonProperty(value="x") double x, @JsonProperty(value="y") double y, @JsonProperty(value="z") double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Position(Position other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Position setX(double x) {
        this.x = x;
        return this;
    }

    public Position setY(double y) {
        this.y = y;
        return this;
    }

    public Position setZ(double z) {
        this.z = z;
        return this;
    }

    public Position add(Position other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
        return this;
    }

    public Position subtract(Position other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
        return this;
    }

    public Position multiply(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public Position divide(double scalar) {
        this.x /= scalar;
        this.y /= scalar;
        this.z /= scalar;
        return this;
    }

    public Position negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public double dot(Position other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Position crossProduct(Position other) {
        return new Position(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Position normalize() {
        double length = this.length();
        if (length == 0.0) {
            return this;
        }
        return this.multiply(1.0 / length);
    }

    public Position floor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.z = Math.floor(this.z);
        return this;
    }

    public Position ceil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        this.z = Math.ceil(this.z);
        return this;
    }

    public Position round() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        this.z = Math.round(this.z);
        return this;
    }

    public Position round(int places) {
        this.x = (double)Math.round(this.x * Math.pow(10.0, places)) / Math.pow(10.0, places);
        this.y = (double)Math.round(this.y * Math.pow(10.0, places)) / Math.pow(10.0, places);
        this.z = (double)Math.round(this.z * Math.pow(10.0, places)) / Math.pow(10.0, places);
        return this;
    }

    public Position abs() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        return this;
    }

    public double distanceSquared(Position other) {
        return (this.x - other.x) * (this.x - other.x) + (this.y - other.y) * (this.y - other.y) + (this.z - other.z) * (this.z - other.z);
    }

    public double distance(Position other) {
        return Math.sqrt(this.distanceSquared(other));
    }

    public Position copy() {
        return new Position(this);
    }

    @JsonIgnore
    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public Position immutable() {
        return new ImmutablePosition(this);
    }

    @ApiStatus.AvailableSince(value="0.0.30")
    public Rotation lookAt(Position target) {
        double dx = target.x - this.x;
        double dy = target.y - this.y;
        double dz = target.z - this.z;
        double yaw = Math.atan2(dx, dz);
        double pitch = Math.atan2(dy, Math.sqrt(dx * dx + dz * dz));
        yaw = Math.toDegrees(yaw);
        pitch = Math.toDegrees(pitch);
        return new Rotation((float)yaw, (float)pitch);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public String toString() {
        return this.x + " " + this.y + " " + this.z;
    }

    public static Position fromDirection(double rotX, double rotY) {
        rotX = Math.toRadians(rotX);
        rotY = Math.toRadians(rotY);
        double xz = Math.cos(rotY);
        return new Position(xz * Math.sin(-rotX), Math.sin(rotY), xz * Math.cos(rotX));
    }
}

