/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.scoreboard.team;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.apartium.cocoabeans.scoreboard.ViewerGroup;
import net.apartium.cocoabeans.scoreboard.team.ChatFormatting;
import net.apartium.cocoabeans.scoreboard.team.CollisionRule;
import net.apartium.cocoabeans.scoreboard.team.NameTagVisibilityRule;
import net.apartium.cocoabeans.state.LazyWatcher;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.state.SetObservable;
import net.apartium.cocoabeans.structs.Entry;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.41")
public abstract class DisplayTeam<P> {
    protected final String name;
    protected final LazyWatcher<Set<String>> entities = LazyWatcher.create(Observable.set());
    protected final ViewerGroup<P> group;
    protected final LazyWatcher<Set<P>> groupWatcher;
    protected final LazyWatcher<Component> displayName = LazyWatcher.create(Observable.empty());
    protected final LazyWatcher<NameTagVisibilityRule> nameTagVisibilityRule = LazyWatcher.create(Observable.immutable(NameTagVisibilityRule.ALWAYS));
    protected final LazyWatcher<CollisionRule> collisionRule = LazyWatcher.create(Observable.immutable(CollisionRule.ALWAYS));
    protected final LazyWatcher<Component> prefix = LazyWatcher.create(Observable.empty());
    protected final LazyWatcher<Component> suffix = LazyWatcher.create(Observable.empty());
    protected final LazyWatcher<ChatFormatting> formatting = LazyWatcher.create(Observable.immutable(ChatFormatting.RESET));
    protected final LazyWatcher<Byte> friendlyFire = LazyWatcher.create(Observable.immutable((byte)0));

    protected DisplayTeam(String name, ViewerGroup<P> group) {
        this.name = name;
        this.group = group;
        this.groupWatcher = LazyWatcher.create(group.observePlayers());
    }

    protected Set<P> currentWatcher() {
        return Optional.ofNullable(this.groupWatcher.getLastValue()).orElse(Set.of());
    }

    protected boolean isDirty() {
        return this.displayName.isDirty() || this.nameTagVisibilityRule.isDirty() || this.collisionRule.isDirty() || this.prefix.isDirty() || this.suffix.isDirty() || this.formatting.isDirty() || this.friendlyFire.isDirty();
    }

    public void heartbeat() {
        this.heartbeatEntities();
        this.heartbeatSettings();
        this.heartbeatAudience();
    }

    private void heartbeatSettings() {
        if (!this.isDirty()) {
            return;
        }
        boolean hadChange = false;
        Entry<Object, Boolean> current = this.displayName.getOrUpdate();
        if (current.value().booleanValue()) {
            hadChange = true;
        }
        Component displayName = current.key();
        current = this.nameTagVisibilityRule.getOrUpdate();
        if (current.value().booleanValue()) {
            hadChange = true;
        }
        NameTagVisibilityRule nameTagVisibilityRule = (NameTagVisibilityRule)((Object)current.key());
        current = this.collisionRule.getOrUpdate();
        if (current.value().booleanValue()) {
            hadChange = true;
        }
        CollisionRule collisionRule = (CollisionRule)((Object)current.key());
        current = this.prefix.getOrUpdate();
        if (current.value().booleanValue()) {
            hadChange = true;
        }
        Component prefix = (Component)current.key();
        current = this.suffix.getOrUpdate();
        if (current.value().booleanValue()) {
            hadChange = true;
        }
        Component suffix = (Component)current.key();
        current = this.formatting.getOrUpdate();
        if (current.value().booleanValue()) {
            hadChange = true;
        }
        ChatFormatting formatting = (ChatFormatting)((Object)current.key());
        current = this.friendlyFire.getOrUpdate();
        if (current.value().booleanValue()) {
            hadChange = true;
        }
        Byte friendlyFire = (Byte)current.key();
        if (!hadChange) {
            return;
        }
        this.sendUpdateTeamPacket(this.currentWatcher(), displayName, friendlyFire, nameTagVisibilityRule, collisionRule, formatting, prefix, suffix);
    }

    private void heartbeatAudience() {
        Entry<Set<P>, Boolean> entry;
        if (!this.groupWatcher.isDirty()) {
            return;
        }
        Set<Object> cache = this.groupWatcher.getLastValue();
        if (cache == null) {
            cache = Set.of();
        }
        if (!(entry = this.groupWatcher.getOrUpdate()).value().booleanValue()) {
            return;
        }
        HashSet toAdd = new HashSet(entry.key());
        toAdd.removeAll(cache);
        HashSet<P> toRemove = new HashSet<P>(cache);
        toRemove.removeAll((Collection)entry.key());
        this.sendCreateTeamPacket(toAdd, this.displayName.getLastValue(), Optional.ofNullable(this.friendlyFire.getLastValue()).orElse((byte)1), this.nameTagVisibilityRule.getLastValue(), this.collisionRule.getLastValue(), this.formatting.getLastValue(), this.prefix.getLastValue(), this.suffix.getLastValue(), Optional.ofNullable(this.entities.getLastValue()).orElse(Set.of()));
        this.sendRemoveTeamPacket(toRemove);
    }

    private void heartbeatEntities() {
        Entry<Set<String>, Boolean> entry;
        if (!this.entities.isDirty()) {
            return;
        }
        Set<String> cacheEntities = this.entities.getLastValue();
        if (cacheEntities == null) {
            cacheEntities = Set.of();
        }
        if (!(entry = this.entities.getOrUpdate()).value().booleanValue()) {
            return;
        }
        HashSet<String> toAdd = new HashSet<String>((Collection)entry.key());
        toAdd.removeAll(cacheEntities);
        HashSet<String> toRemove = new HashSet<String>(cacheEntities);
        toRemove.removeAll((Collection)entry.key());
        if (!toAdd.isEmpty()) {
            this.sendAddEntitiesPacket(this.currentWatcher(), toAdd);
        }
        if (!toRemove.isEmpty()) {
            this.sendRemoveEntitiesPacket(this.currentWatcher(), toRemove);
        }
    }

    public ViewerGroup<P> getViewers() {
        return this.group;
    }

    public DisplayTeam<P> addEntity(String ... entity) {
        ((SetObservable)this.entities.getWatchedObservable()).addAll(Set.of(entity));
        return this;
    }

    public SetObservable<String> getEntities() {
        return (SetObservable)this.entities.getWatchedObservable();
    }

    public DisplayTeam<P> removeEntity(String ... entity) {
        ((SetObservable)this.entities.getWatchedObservable()).removeAll(Set.of(entity));
        return this;
    }

    public DisplayTeam<P> setDisplayName(Observable<Component> displayName) {
        this.displayName.setDependsOn(displayName);
        return this;
    }

    public DisplayTeam<P> setNameTagVisibilityRule(Observable<NameTagVisibilityRule> nameTagVisibilityRule) {
        this.nameTagVisibilityRule.setDependsOn(nameTagVisibilityRule);
        return this;
    }

    public DisplayTeam<P> setCollisionRule(Observable<CollisionRule> collisionRule) {
        this.collisionRule.setDependsOn(collisionRule);
        return this;
    }

    public DisplayTeam<P> setPrefix(Observable<Component> prefix) {
        this.prefix.setDependsOn(prefix);
        return this;
    }

    public DisplayTeam<P> setSuffix(Observable<Component> suffix) {
        this.suffix.setDependsOn(suffix);
        return this;
    }

    public DisplayTeam<P> setFormatting(Observable<ChatFormatting> formatting) {
        this.formatting.setDependsOn(formatting);
        return this;
    }

    public DisplayTeam<P> setFriendlyFire(Observable<Byte> friendlyFire) {
        this.friendlyFire.setDependsOn(friendlyFire);
        return this;
    }

    public void delete() {
        this.sendRemoveTeamPacket(this.currentWatcher());
        this.entities.delete();
        this.displayName.delete();
        this.nameTagVisibilityRule.delete();
        this.collisionRule.delete();
        this.prefix.delete();
        this.suffix.delete();
        this.formatting.delete();
        this.friendlyFire.delete();
    }

    @ApiStatus.Internal
    public abstract void sendUpdateTeamPacket(Set<P> var1, Component var2, byte var3, NameTagVisibilityRule var4, CollisionRule var5, ChatFormatting var6, Component var7, Component var8);

    @ApiStatus.Internal
    public abstract void sendAddEntitiesPacket(Set<P> var1, Collection<String> var2);

    @ApiStatus.Internal
    public abstract void sendRemoveEntitiesPacket(Set<P> var1, Collection<String> var2);

    @ApiStatus.Internal
    public abstract void sendCreateTeamPacket(Set<P> var1, Component var2, byte var3, NameTagVisibilityRule var4, CollisionRule var5, ChatFormatting var6, Component var7, Component var8, Collection<String> var9);

    @ApiStatus.Internal
    public abstract void sendRemoveTeamPacket(Set<P> var1);
}

