/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.scoreboard;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.apartium.cocoabeans.scoreboard.DisplaySlot;
import net.apartium.cocoabeans.scoreboard.ObjectiveMode;
import net.apartium.cocoabeans.scoreboard.ObjectiveRenderType;
import net.apartium.cocoabeans.scoreboard.ScoreboardAction;
import net.apartium.cocoabeans.scoreboard.ViewerGroup;
import net.apartium.cocoabeans.state.CompoundRecords;
import net.apartium.cocoabeans.state.LazyWatcher;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.state.SetObservable;
import net.apartium.cocoabeans.structs.Entry;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.41")
public abstract class ScoreboardNumericDisplay<P> {
    protected final String objectiveId;
    protected final ViewerGroup<P> group;
    protected final LazyWatcher<Set<P>> groupWatcher;
    protected final Set<DisplaySlot> displaySlots;
    protected final Map<String, LazyWatcher<CompoundRecords.RecordOf3<Integer, Component, Style>>> entities = new HashMap<String, LazyWatcher<CompoundRecords.RecordOf3<Integer, Component, Style>>>();
    protected final LazyWatcher<Component> displayName;
    protected ObjectiveRenderType renderType = ObjectiveRenderType.INTEGER;

    protected ScoreboardNumericDisplay(String objectiveId, ViewerGroup<P> group, Observable<Component> displayName) {
        this.objectiveId = objectiveId;
        this.group = group;
        SetObservable<P> players = group.observePlayers();
        this.groupWatcher = LazyWatcher.create(players);
        this.displaySlots = Collections.newSetFromMap(new IdentityHashMap());
        this.displayName = displayName.lazyWatch();
    }

    public ViewerGroup<P> getViewers() {
        return this.group;
    }

    protected Set<P> currentWatcher() {
        return Optional.ofNullable(this.groupWatcher.getLastValue()).orElse(Set.of());
    }

    public void set(String entity, Observable<Integer> score, Observable<Component> suffix, Observable<Style> style) {
        Observable<CompoundRecords.RecordOf3<Integer, Object, Object>> compound = Observable.compound(score == Observable.empty() ? Observable.immutable(0) : Optional.ofNullable(score).orElse(Observable.immutable(0)), suffix == Observable.empty() ? Observable.immutable(null) : Optional.ofNullable(suffix).orElse(Observable.immutable(null)), style == Observable.empty() ? Observable.immutable(null) : Optional.ofNullable(style).orElse(Observable.immutable(Style.style((TextColor)NamedTextColor.RED))));
        LazyWatcher<CompoundRecords.RecordOf3<Integer, Object, Object>> watcher = compound.lazyWatch();
        this.entities.put(entity, watcher);
        CompoundRecords.RecordOf3<Integer, Object, Object> record = watcher.getOrUpdate().key();
        this.sendScorePacket(this.currentWatcher(), entity, record.arg0(), ScoreboardAction.CREATE_OR_UPDATE, record.arg1(), record.arg2());
    }

    public void heartbeat() {
        Entry<Component, Boolean> entry;
        if (this.displayName.isDirty() && (entry = this.displayName.getOrUpdate()).value().booleanValue()) {
            this.sendObjectivePacket(this.currentWatcher(), ObjectiveMode.UPDATE, Optional.ofNullable(entry.key()).orElse((Component)Component.empty()));
        }
        for (Map.Entry<String, LazyWatcher<CompoundRecords.RecordOf3<Integer, Component, Style>>> entry2 : this.entities.entrySet()) {
            Entry<CompoundRecords.RecordOf3<Integer, Component, Style>, Boolean> record;
            if (!entry2.getValue().isDirty() || !(record = entry2.getValue().getOrUpdate()).value().booleanValue()) continue;
            this.sendScorePacket(this.currentWatcher(), entry2.getKey(), record.key().arg0(), ScoreboardAction.CREATE_OR_UPDATE, record.key().arg1(), record.key().arg2());
        }
        this.handleNewAudience();
    }

    private void handleNewAudience() {
        if (this.groupWatcher.isDirty()) {
            Set cache = Optional.ofNullable(this.groupWatcher.getLastValue()).orElse(Collections.emptySet());
            Entry<Set<P>, Boolean> entry = this.groupWatcher.getOrUpdate();
            if (!entry.value().booleanValue()) {
                return;
            }
            HashSet toAdd = new HashSet(entry.key());
            toAdd.removeAll(cache);
            HashSet toRemove = new HashSet(cache);
            toRemove.removeAll((Collection)entry.key());
            this.sendObjectivePacket(toAdd, ObjectiveMode.CREATE, Optional.ofNullable(this.displayName.getLastValue()).orElse((Component)Component.empty()));
            for (DisplaySlot displaySlot : this.displaySlots) {
                this.sendDisplayPacket(toAdd, displaySlot, this.objectiveId);
            }
            for (Map.Entry entry2 : this.entities.entrySet()) {
                CompoundRecords.RecordOf3 record = (CompoundRecords.RecordOf3)((LazyWatcher)entry2.getValue()).getLastValue();
                this.sendScorePacket(toAdd, (String)entry2.getKey(), (Integer)record.arg0(), ScoreboardAction.CREATE_OR_UPDATE, (Component)record.arg1(), (Style)record.arg2());
            }
            this.sendObjectivePacket(toRemove, ObjectiveMode.REMOVE, null);
        }
    }

    public void remove(String entity) {
        LazyWatcher<CompoundRecords.RecordOf3<Integer, Component, Style>> record = this.entities.remove(entity);
        if (record == null) {
            return;
        }
        this.sendScorePacket(this.currentWatcher(), entity, 0, ScoreboardAction.REMOVE, null, null);
        record.delete();
    }

    public void addDisplaySlot(DisplaySlot slot) {
        if (!this.displaySlots.add(slot)) {
            return;
        }
        this.sendDisplayPacket(this.currentWatcher(), slot, this.objectiveId);
    }

    public void removeDisplaySlot(DisplaySlot slot) {
        if (!this.displaySlots.remove((Object)slot)) {
            return;
        }
        this.sendDisplayPacket(this.currentWatcher(), slot, null);
    }

    public void renderType(ObjectiveRenderType type) {
        if (this.renderType == type) {
            return;
        }
        this.renderType = type;
        this.sendObjectivePacket(this.currentWatcher(), ObjectiveMode.UPDATE, Optional.ofNullable(this.displayName.getOrUpdate().key()).orElse((Component)Component.empty()));
    }

    public void displayName(Observable<Component> displayName) {
        this.displayName.setDependsOn(displayName);
    }

    public void delete() {
        this.sendObjectivePacket(this.currentWatcher(), ObjectiveMode.REMOVE, null);
        for (LazyWatcher<CompoundRecords.RecordOf3<Integer, Component, Style>> value : this.entities.values()) {
            value.delete();
        }
        this.entities.clear();
        this.displaySlots.clear();
        this.displayName.delete();
        this.groupWatcher.delete();
    }

    protected abstract void sendDisplayPacket(Set<P> var1, DisplaySlot var2, String var3);

    protected abstract void sendScorePacket(Set<P> var1, String var2, int var3, ScoreboardAction var4, Component var5, Style var6);

    protected abstract void sendObjectivePacket(Set<P> var1, ObjectiveMode var2, Component var3);
}

