/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;

class ReflectionCache {
    private static final ClassValue<ClassCachedData> CLASS_CACHE_REF = new ClassValue<ClassCachedData>(){

        @Override
        protected ClassCachedData computeValue(Class<?> type) {
            return new ClassCachedData();
        }
    };

    ReflectionCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Stream<Constructor> getDeclaredConstructors(Class<?> clazz) {
        ClassCachedData result = ReflectionCache.getCachedData(clazz);
        if (result.constructors == null) {
            ClassCachedData classCachedData = result;
            synchronized (classCachedData) {
                if (result.constructors == null) {
                    result.constructors = (Constructor[])ReflectionCache.setAccessible((AccessibleObject[])clazz.getDeclaredConstructors());
                }
            }
        }
        return Stream.of(result.constructors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Stream<Field> getDeclaredFields(Class<?> clazz) {
        ClassCachedData result = ReflectionCache.getCachedData(clazz);
        if (result.declaredFields == null) {
            ClassCachedData classCachedData = result;
            synchronized (classCachedData) {
                if (result.declaredFields == null) {
                    result.declaredFields = (Field[])ReflectionCache.setAccessible((AccessibleObject[])clazz.getDeclaredFields());
                }
            }
        }
        return Stream.of(result.declaredFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Stream<Field> getFields(Class<?> clazz) {
        ClassCachedData result = ReflectionCache.getCachedData(clazz);
        if (result.fields == null) {
            ClassCachedData classCachedData = result;
            synchronized (classCachedData) {
                if (result.fields == null) {
                    result.fields = (Field[])ReflectionCache.setAccessible((AccessibleObject[])clazz.getFields());
                }
            }
        }
        return Stream.of(result.fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Stream<Method> getMethods(Class<?> clazz) {
        ClassCachedData result = ReflectionCache.getCachedData(clazz);
        if (result.methods == null) {
            ClassCachedData classCachedData = result;
            synchronized (classCachedData) {
                if (result.methods == null) {
                    result.methods = (Method[])ReflectionCache.setAccessible((AccessibleObject[])clazz.getMethods());
                }
            }
        }
        return Stream.of(result.methods);
    }

    static Method getMethod(Class<?> clazz, String name, Class<?>[] params) {
        return ReflectionCache.getMethods(clazz).filter(method -> method.getName().equals(name) && Arrays.equals(method.getParameterTypes(), params)).findAny().orElse(null);
    }

    static Method getDeclaredMethod(Class<?> clazz, String name, Class<?>[] params) {
        return ReflectionCache.getDeclaredMethods(clazz).filter(method -> method.getName().equals(name) && Arrays.equals(method.getParameterTypes(), params)).findAny().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Stream<Method> getDeclaredMethods(Class<?> clazz) {
        ClassCachedData result = ReflectionCache.getCachedData(clazz);
        if (result.declaredMethods == null) {
            ClassCachedData classCachedData = result;
            synchronized (classCachedData) {
                if (result.declaredMethods == null) {
                    result.declaredMethods = (Method[])Arrays.stream(clazz.getDeclaredMethods()).filter(method -> !method.isSynthetic()).peek(method -> method.setAccessible(true)).toArray(Method[]::new);
                }
            }
        }
        return Stream.of(result.declaredMethods);
    }

    private static ClassCachedData getCachedData(Class<?> clazz) {
        return CLASS_CACHE_REF.get(clazz);
    }

    private static <T extends AccessibleObject> T[] setAccessible(T[] array) {
        for (T object : array) {
            ((AccessibleObject)object).setAccessible(true);
        }
        return array;
    }

    private static class ClassCachedData {
        private Field[] fields;
        private Field[] declaredFields;
        private Method[] methods;
        private Method[] declaredMethods;
        private Constructor[] constructors;

        private ClassCachedData() {
        }
    }
}

