/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.spigot.requirements.factory;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.apartium.cocoabeans.CollectionHelpers;
import net.apartium.cocoabeans.commands.GenericNode;
import net.apartium.cocoabeans.commands.requirements.Requirement;
import net.apartium.cocoabeans.commands.requirements.RequirementEvaluationContext;
import net.apartium.cocoabeans.commands.requirements.RequirementFactory;
import net.apartium.cocoabeans.commands.requirements.RequirementResult;
import net.apartium.cocoabeans.commands.requirements.UnmetRequirementResponse;
import net.apartium.cocoabeans.commands.spigot.SenderType;
import net.apartium.cocoabeans.commands.spigot.exception.SenderLimitException;
import net.apartium.cocoabeans.commands.spigot.requirements.SenderLimit;
import org.jetbrains.annotations.Nullable;

public class SenderLimitFactory
implements RequirementFactory {
    @Override
    @Nullable
    public Requirement getRequirement(GenericNode node, Object obj) {
        if (!(obj instanceof SenderLimit)) {
            return null;
        }
        SenderLimit senderLimit = (SenderLimit)obj;
        return new SenderLimitImpl(senderLimit, senderLimit.value(), senderLimit.invert());
    }

    private static class SenderLimitImpl
    implements Requirement {
        private final SenderLimit senderLimit;
        private final EnumSet<SenderType> senderTypes;
        private final boolean invert;

        public SenderLimitImpl(SenderLimit senderLimit, SenderType[] senderTypes, boolean invert) {
            this.senderLimit = senderLimit;
            this.senderTypes = EnumSet.copyOf(Arrays.asList(senderTypes));
            this.invert = invert;
        }

        @Override
        public RequirementResult meetsRequirement(RequirementEvaluationContext context) {
            for (SenderType senderType : this.senderTypes) {
                RequirementResult requirementResult = senderType.meetsRequirement(context);
                if (this.invert) {
                    if (!requirementResult.meetRequirement()) continue;
                    return RequirementResult.error(new UnmetSenderLimit(this, context, "This command can not be used by " + String.join((CharSequence)", ", this.senderTypes.stream().map(Enum::name).toList().toArray(new String[0])) + "s"));
                }
                if (!requirementResult.meetRequirement()) continue;
                return requirementResult;
            }
            if (this.invert) {
                return RequirementResult.meet();
            }
            return RequirementResult.error(new UnmetSenderLimit(this, context, "This command can only be used by " + String.join((CharSequence)", ", this.senderTypes.stream().map(Enum::name).toList().toArray(new String[0])) + "s"));
        }

        @Override
        public List<Class<?>> getTypes() {
            return List.of(SenderType.class);
        }

        public String toString() {
            return "SenderLimit: [" + String.join((CharSequence)", ", this.senderTypes.stream().map(Enum::name).toList().toArray(new String[0])) + "]";
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SenderLimitImpl)) {
                return false;
            }
            SenderLimitImpl other = (SenderLimitImpl)obj;
            if (this.senderTypes.size() != other.senderTypes.size()) {
                return false;
            }
            if (this.invert != other.invert) {
                return false;
            }
            if (this.senderTypes.isEmpty()) {
                return true;
            }
            return CollectionHelpers.equalsArray(this.senderTypes.toArray(new SenderType[0]), other.senderTypes.toArray(new SenderType[0]));
        }

        private class UnmetSenderLimit
        extends UnmetRequirementResponse {
            public UnmetSenderLimit(Requirement requirement, RequirementEvaluationContext context, String message) {
                super(requirement, context, message, SenderLimitImpl.this.senderLimit);
            }

            @Override
            public SenderLimitException getError() {
                return new SenderLimitException((UnmetRequirementResponse)this, SenderLimitImpl.this.senderLimit);
            }
        }
    }
}

