/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.spigot.parsers;

import net.apartium.cocoabeans.commands.lexer.SimpleCommandLexer;
import net.apartium.cocoabeans.commands.parsers.CompoundParser;
import net.apartium.cocoabeans.commands.parsers.DoubleParser;
import net.apartium.cocoabeans.commands.parsers.FloatParser;
import net.apartium.cocoabeans.commands.parsers.ParserVariant;
import net.apartium.cocoabeans.commands.parsers.WithParser;
import net.apartium.cocoabeans.commands.parsers.WithParsers;
import net.apartium.cocoabeans.commands.parsers.WrappedArgumentParser;
import net.apartium.cocoabeans.commands.spigot.SenderType;
import net.apartium.cocoabeans.commands.spigot.SpigotArgumentMapper;
import net.apartium.cocoabeans.commands.spigot.parsers.WorldParser;
import net.apartium.cocoabeans.commands.spigot.requirements.SenderLimit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

public class LocationParser
extends WrappedArgumentParser<Location> {
    public static final String DEFAULT_KEYWORD = "location";
    private static LocationParserImpl impl = LocationParser.getImpl();

    private static LocationParserImpl getImpl() {
        if (impl == null) {
            impl = new LocationParserImpl(DEFAULT_KEYWORD, 0);
        }
        return impl;
    }

    public LocationParser(int priority, String keyword) {
        super(impl, priority, keyword);
    }

    public LocationParser(int priority) {
        this(priority, DEFAULT_KEYWORD);
    }

    @WithParsers(value={@WithParser(value=DoubleParser.class), @WithParser(value=FloatParser.class), @WithParser(value=WorldParser.class)})
    @ApiStatus.AvailableSince(value="0.0.38")
    private static class LocationParserImpl
    extends CompoundParser<Location> {
        public LocationParserImpl(String keyword, int priority) {
            super(keyword, Location.class, priority, new SpigotArgumentMapper(), new SimpleCommandLexer());
        }

        @ParserVariant(value="<world> <double> <double> <double>")
        public Location parseWorldWithXyz(World world, double x, double y, double z) {
            return new Location(world, x, y, z);
        }

        @ParserVariant(value="<world> <double> <double> <double> <float> <float>")
        public Location parseWorldWithXyzYawPitch(World world, double x, double y, double z, float yaw, float pitch) {
            return new Location(world, x, y, z, yaw, pitch);
        }

        @SenderLimit(value={SenderType.PLAYER})
        @ParserVariant(value="<double> <double> <double>")
        public Location parseWithXyz(Player sender, double x, double y, double z) {
            return new Location(sender.getWorld(), x, y, z);
        }

        @SenderLimit(value={SenderType.PLAYER})
        @ParserVariant(value="<double> <double> <double> <float> <float>")
        public Location parseWithXyzYawPitch(Player sender, double x, double y, double z, float yaw, float pitch) {
            return new Location(sender.getWorld(), x, y, z, yaw, pitch);
        }
    }
}

