/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.spigot;

import java.util.List;
import java.util.Map;
import net.apartium.cocoabeans.commands.ArgumentConverter;
import net.apartium.cocoabeans.commands.ArgumentIndex;
import net.apartium.cocoabeans.commands.SimpleArgumentMapper;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpigotArgumentMapper
extends SimpleArgumentMapper {
    public SpigotArgumentMapper() {
        this(List.of());
    }

    public SpigotArgumentMapper(List<ArgumentConverter<?>> converters) {
        super(converters);
    }

    @Override
    protected ArgumentIndex<?> resolveBuiltInArgumentIndex(Class<?> type, Map<Class<?>, Integer> counterMap, Map<Class<?>, List<ArgumentIndex<?>>> mapOfArguments, int index) {
        ArgumentIndex<?> argumentIndex = super.resolveBuiltInArgumentIndex(type, counterMap, mapOfArguments, index);
        if (argumentIndex != null) {
            return argumentIndex;
        }
        for (ArgumentConverter converter : this.converters) {
            if (!type.isAssignableFrom(converter.targetType()) || !converter.isSourceTypeSupported(CommandSender.class)) continue;
            return this.map(converter, this.getSpigotSenderIndex(CommandSender.class, counterMap, mapOfArguments, index));
        }
        if (CommandSender.class.isAssignableFrom(type)) {
            return this.getSpigotSenderIndex(type, counterMap, mapOfArguments, index);
        }
        return null;
    }

    protected ArgumentIndex<?> getSpigotSenderIndex(Class<?> type, Map<Class<?>, Integer> counterMap, Map<Class<?>, List<ArgumentIndex<?>>> mapOfArguments, int index) {
        boolean hasSender;
        if (type == CommandSender.class && index == 0) {
            return context -> (CommandSender)context.sender().getSender();
        }
        boolean bl = hasSender = counterMap.getOrDefault(CommandSender.class, 0) != 0;
        if (type == Player.class && !hasSender) {
            counterMap.put(CommandSender.class, 1);
            counterMap.put(Player.class, -1);
            return context -> {
                Object patt3172$temp = context.sender().getSender();
                if (!(patt3172$temp instanceof Player)) {
                    throw new IllegalArgumentException("Sender is not a player");
                }
                Player player = (Player)patt3172$temp;
                return player;
            };
        }
        return mapOfArguments.get(type).get(index);
    }
}

