/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.requirements;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.apartium.cocoabeans.commands.GenericNode;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirement;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirementType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface ArgumentRequirementFactory {
    @ApiStatus.AvailableSince(value="0.0.37")
    public static ArgumentRequirement[] createArgumentRequirements(GenericNode node, Annotation[] annotations, Map<Class<? extends ArgumentRequirementFactory>, ArgumentRequirementFactory> argumentRequirementFactories) {
        if (annotations == null) {
            return new ArgumentRequirement[0];
        }
        ArrayList<ArgumentRequirement> result = new ArrayList<ArgumentRequirement>();
        for (Annotation annotation : annotations) {
            ArgumentRequirement argumentRequirement;
            Class<? extends ArgumentRequirementFactory> argumentRequirementType = ArgumentRequirementFactory.getArgumentRequirementFactoryClass(annotation);
            if (argumentRequirementType == null || (argumentRequirement = (ArgumentRequirement)Optional.ofNullable(argumentRequirementFactories.computeIfAbsent(argumentRequirementType, clazz -> ArgumentRequirementFactory.createFromAnnotation(annotation))).map(factory -> factory.getArgumentRequirement(node, annotation)).orElse(null)) == null) continue;
            result.add(argumentRequirement);
        }
        return result.toArray(new ArgumentRequirement[0]);
    }

    @ApiStatus.AvailableSince(value="0.0.37")
    public static Class<? extends ArgumentRequirementFactory> getArgumentRequirementFactoryClass(Annotation annotation) {
        if (annotation == null) {
            return null;
        }
        ArgumentRequirementType argumentRequirementType = annotation.annotationType().getAnnotation(ArgumentRequirementType.class);
        return argumentRequirementType == null ? null : argumentRequirementType.value();
    }

    @ApiStatus.AvailableSince(value="0.0.37")
    public static ArgumentRequirementFactory createFromAnnotation(Annotation annotation) {
        if (annotation == null) {
            return null;
        }
        Class<? extends ArgumentRequirementFactory> clazz = ArgumentRequirementFactory.getArgumentRequirementFactoryClass(annotation);
        if (clazz == null) {
            return null;
        }
        try {
            Constructor<? extends ArgumentRequirementFactory> constructor = clazz.getConstructor(new Class[0]);
            if (constructor.getParameterCount() == 0) {
                return constructor.newInstance(new Object[0]);
            }
            return null;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate argument requirement factory: " + String.valueOf(clazz), e);
        }
    }

    @Nullable
    public ArgumentRequirement getArgumentRequirement(GenericNode var1, Object var2);
}

