/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers.factory;

import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.apartium.cocoabeans.StringHelpers;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.GenericNode;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.parsers.IntRangeParser;
import net.apartium.cocoabeans.commands.parsers.ParserFactory;
import net.apartium.cocoabeans.commands.parsers.Scope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class IntRangeParserFactory
implements ParserFactory {
    @Override
    @NotNull
    public Collection<ParserFactory.ParserResult> getArgumentParser(GenericNode node, Annotation annoation, GenericDeclaration obj) {
        if (!(annoation instanceof IntRangeParser)) {
            return Collections.emptyList();
        }
        IntRangeParser intRangeParser = (IntRangeParser)annoation;
        if (intRangeParser.from() > intRangeParser.to()) {
            throw new RuntimeException("from must be smaller than to");
        }
        if (intRangeParser.step() <= 0) {
            throw new RuntimeException("step must be larger than 0");
        }
        if (intRangeParser.to() - intRangeParser.from() <= intRangeParser.step()) {
            throw new RuntimeException("step must be smaller than to - from");
        }
        return List.of(new ParserFactory.ParserResult(new IntRangeParserImpl(intRangeParser.from(), intRangeParser.to(), intRangeParser.step(), intRangeParser.keyword(), intRangeParser.priority()), obj instanceof Method ? Scope.VARIANT : Scope.CLASS));
    }

    private class IntRangeParserImpl
    extends ArgumentParser<Integer> {
        private final int from;
        private final int to;
        private final int step;

        public IntRangeParserImpl(int from, int to, int step, String keyword, int priority) {
            super(keyword, Integer.TYPE, priority);
            this.from = from;
            this.to = to;
            this.step = step;
        }

        @Override
        public Optional<ArgumentParser.ParseResult<Integer>> parse(CommandProcessingContext processingContext) {
            int index;
            List<String> args = processingContext.args();
            OptionalInt optionalInt = StringHelpers.parseInteger(args.get(index = processingContext.index()));
            if (optionalInt.isEmpty()) {
                return Optional.empty();
            }
            int targetNum = optionalInt.getAsInt();
            if (targetNum < this.from) {
                return Optional.empty();
            }
            if (targetNum >= this.to) {
                return Optional.empty();
            }
            if ((targetNum - this.from) % this.step != 0) {
                return Optional.empty();
            }
            return Optional.of(new ArgumentParser.ParseResult<Integer>(targetNum, index + 1));
        }

        @Override
        public OptionalInt tryParse(CommandProcessingContext processingContext) {
            int index;
            List<String> args = processingContext.args();
            OptionalInt optionalInt = StringHelpers.parseInteger(args.get(index = processingContext.index()));
            if (optionalInt.isEmpty()) {
                return OptionalInt.empty();
            }
            int targetNum = optionalInt.getAsInt();
            if (targetNum < this.from) {
                return OptionalInt.empty();
            }
            if (targetNum >= this.to) {
                return OptionalInt.empty();
            }
            if ((targetNum - this.from) % this.step != 0) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(index + 1);
        }

        @Override
        public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
            int index;
            OptionalInt optionalInt;
            List<String> args = processingContext.args();
            OptionalInt optionalInt2 = optionalInt = args.get(index = processingContext.index()).isEmpty() ? OptionalInt.of(0) : StringHelpers.parseInteger(args.get(index));
            if (optionalInt.isEmpty()) {
                return Optional.empty();
            }
            int targetNum = optionalInt.getAsInt();
            if (targetNum >= this.to) {
                return Optional.empty();
            }
            HashSet<CallSite> allPossiblesOptions = new HashSet<CallSite>();
            for (int i = Math.max(targetNum * 10, this.from); i < this.to; i += this.step) {
                allPossiblesOptions.add((CallSite)((Object)("" + i)));
            }
            return Optional.of(new ArgumentParser.TabCompletionResult(allPossiblesOptions.stream().filter(s -> s.startsWith((String)(((String)args.get(index)).isEmpty() ? "" : "" + targetNum))).collect(Collectors.toSet()), index + 1));
        }
    }
}

