/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.apartium.cocoabeans.CollectionHelpers;
import net.apartium.cocoabeans.commands.GenericNode;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.parsers.CommandParserFactory;
import net.apartium.cocoabeans.commands.parsers.Scope;
import net.apartium.cocoabeans.reflect.ClassUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.AvailableSince(value="0.0.30")
public interface ParserFactory {
    @ApiStatus.AvailableSince(value="0.0.37")
    public static Map<String, ArgumentParser<?>> findClassParsers(GenericNode node, Class<?> clazz, Map<Class<? extends ParserFactory>, ParserFactory> parserFactories) {
        HashMap result = new HashMap();
        for (Class<?> c : ClassUtils.getSuperClassAndInterfaces(clazz)) {
            CollectionHelpers.mergeInto(result, ParserFactory.getArgumentParsers(node, c.getAnnotations(), c, true, parserFactories));
            for (Method method : c.getMethods()) {
                try {
                    result.putAll(ParserFactory.getArgumentParsers(node, method.getAnnotations(), (GenericDeclaration)clazz.getMethod(method.getName(), method.getParameterTypes()), true, parserFactories));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @ApiStatus.AvailableSince(value="0.0.37")
    public static Map<String, ArgumentParser<?>> getArgumentParsers(GenericNode node, Annotation[] annotations, GenericDeclaration obj, boolean limitToClassParsers, Map<Class<? extends ParserFactory>, ParserFactory> parserFactories) {
        HashMap result = new HashMap();
        for (Annotation annotation : annotations) {
            result.putAll(ParserFactory.getArgumentParsers(node, annotation, obj, limitToClassParsers, parserFactories));
        }
        return result;
    }

    @ApiStatus.AvailableSince(value="0.0.37")
    public static Map<String, ArgumentParser<?>> getArgumentParsers(GenericNode node, Annotation annotation, GenericDeclaration obj, boolean limitToClassParsers, Map<Class<? extends ParserFactory>, ParserFactory> parserFactories) {
        Class<? extends ParserFactory> parserFactoryClass = ParserFactory.getParserFactoryClass(annotation);
        if (parserFactoryClass == null) {
            return Map.of();
        }
        ParserFactory parserFactory = parserFactories.computeIfAbsent(parserFactoryClass, clazz -> ParserFactory.createFromAnnotation(annotation, limitToClassParsers));
        if (parserFactory == null) {
            return Map.of();
        }
        Collection<ParserResult> parserResults = parserFactory.getArgumentParser(node, annotation, obj);
        if (parserResults.isEmpty()) {
            return Map.of();
        }
        HashMap result = new HashMap();
        for (ParserResult parseResult : parserResults) {
            if (!parseResult.scope().isClass() && limitToClassParsers) continue;
            result.put(parseResult.parser().getKeyword(), parseResult.parser());
        }
        return result;
    }

    @ApiStatus.AvailableSince(value="0.0.37")
    public static Class<? extends ParserFactory> getParserFactoryClass(Annotation annotation) {
        CommandParserFactory commandParserFactory = annotation.annotationType().getAnnotation(CommandParserFactory.class);
        return commandParserFactory == null ? null : commandParserFactory.value();
    }

    @ApiStatus.AvailableSince(value="0.0.37")
    public static ParserFactory createFromAnnotation(Annotation annotation, boolean onlyClassParser) {
        if (annotation == null) {
            return null;
        }
        CommandParserFactory commandParserFactory = annotation.annotationType().getAnnotation(CommandParserFactory.class);
        if (commandParserFactory == null) {
            return null;
        }
        if (!commandParserFactory.scope().isClass() && onlyClassParser) {
            return null;
        }
        try {
            return commandParserFactory.value().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate parser factory: " + String.valueOf(commandParserFactory.value()), e);
        }
    }

    @NotNull
    public Collection<ParserResult> getArgumentParser(GenericNode var1, Annotation var2, GenericDeclaration var3);

    public record ParserResult(ArgumentParser<?> parser, Scope scope) {
    }
}

