/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.parsers.exception.AmbiguousMappedKeyResponse;
import net.apartium.cocoabeans.commands.parsers.exception.NoSuchElementInMapResponse;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.39")
public abstract class ContextualMapBasedParser<T>
extends ArgumentParser<T> {
    private final boolean ignoreCase;
    private final boolean lax;

    protected ContextualMapBasedParser(String keyword, Class<T> clazz, int priority) {
        this(keyword, clazz, priority, false);
    }

    protected ContextualMapBasedParser(String keyword, Class<T> clazz, int priority, boolean ignoreCase) {
        this(keyword, clazz, priority, ignoreCase, false);
    }

    protected ContextualMapBasedParser(String keyword, Class<T> clazz, int priority, boolean ignoreCase, boolean lax) {
        super(keyword, clazz, priority);
        this.ignoreCase = ignoreCase;
        this.lax = lax;
    }

    public abstract Map<String, T> getMap(CommandProcessingContext var1);

    @Override
    public Optional<ArgumentParser.ParseResult<T>> parse(CommandProcessingContext commandProcessingContext) {
        List<String> args = commandProcessingContext.args();
        int index = commandProcessingContext.index();
        Map<String, T> map = this.getMap(commandProcessingContext);
        StringBuilder sb = new StringBuilder();
        boolean ambiguous = false;
        for (int i = index; i < args.size(); ++i) {
            if (i != index) {
                sb.append(" ");
            }
            sb.append(this.convertBaseOnIgnoreCase(args.get(i)));
            T value = map.get(sb.toString());
            if (value == null) {
                LaxResult<T> result;
                if (!this.lax || (result = this.getLax(commandProcessingContext, sb.toString())) == null) continue;
                if (result.hasAmbiguous()) {
                    ambiguous = true;
                    continue;
                }
                value = result.value();
            }
            return Optional.of(new ArgumentParser.ParseResult<T>(value, i + 1));
        }
        if (ambiguous) {
            return Optional.empty();
        }
        commandProcessingContext.report(this, new NoSuchElementInMapResponse(commandProcessingContext, this, "No such element in map", sb.toString()));
        return Optional.empty();
    }

    private String convertBaseOnIgnoreCase(String s) {
        if (this.ignoreCase) {
            return s.toLowerCase();
        }
        return s;
    }

    private LaxResult<T> getLax(CommandProcessingContext context, String s) {
        Object result = null;
        ArrayList<String> dupeKeys = new ArrayList<String>();
        for (Map.Entry<String, T> entry : this.getMap(context).entrySet()) {
            if (!entry.getKey().startsWith(s)) continue;
            if (result != null) {
                dupeKeys.add(entry.getKey());
                continue;
            }
            result = entry.getValue();
            dupeKeys.add(entry.getKey());
        }
        if (dupeKeys.isEmpty()) {
            return null;
        }
        if (dupeKeys.size() != 1) {
            context.report(this, new AmbiguousMappedKeyResponse(context, this, "Did you mean " + (String)dupeKeys.get(0) + "?", dupeKeys));
            return LaxResult.createHasAmbiguous();
        }
        return new LaxResult<Object>(result, false);
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext commandProcessingContext) {
        return this.parse(commandProcessingContext).map(ArgumentParser.ParseResult::newIndex).map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext commandProcessingContext) {
        List<String> args = commandProcessingContext.args();
        int index = commandProcessingContext.index();
        Set<String> keys = this.getMap(commandProcessingContext).keySet();
        HashSet<String> result = new HashSet<String>();
        String s = String.join((CharSequence)" ", args.subList(index, args.size()));
        for (String key : keys) {
            if (!key.toLowerCase().startsWith(s.toLowerCase())) continue;
            result.add(key);
        }
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ArgumentParser.TabCompletionResult(result, index + 1));
    }

    private record LaxResult<T>(T value, boolean hasAmbiguous) {
        private static <T> LaxResult<T> createHasAmbiguous() {
            return new LaxResult<Object>(null, true);
        }
    }
}

