/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.lexer;

import java.util.Objects;
import net.apartium.cocoabeans.commands.lexer.KeywordToken;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.37")
public class SimpleKeywordToken
extends KeywordToken {
    private final String keyword;

    public SimpleKeywordToken(int from, int to, String text) {
        super(from, to, text);
        this.keyword = text.substring(from, to);
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    public String toString() {
        return "SimpleKeywordToken{keyword='" + this.keyword + "', from=" + this.from + ", to=" + this.to + ", text='" + this.text + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            if (o instanceof KeywordToken) {
                KeywordToken keywordToken = (KeywordToken)o;
                return keywordToken.getKeyword().equals(this.keyword) && keywordToken.from() == this.from && keywordToken.to() == this.to;
            }
            return false;
        }
        SimpleKeywordToken that = (SimpleKeywordToken)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.text, that.text) && Objects.equals(this.keyword, that.keyword);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.text, this.keyword);
    }
}

