/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.lexer;

import java.util.ArrayList;
import java.util.List;
import net.apartium.cocoabeans.commands.lexer.ArgumentParserToken;
import net.apartium.cocoabeans.commands.lexer.CommandLexer;
import net.apartium.cocoabeans.commands.lexer.CommandToken;
import net.apartium.cocoabeans.commands.lexer.CommandTokenSupplier;
import net.apartium.cocoabeans.commands.lexer.KeywordToken;
import net.apartium.cocoabeans.commands.lexer.SimpleArgumentParserToken;
import net.apartium.cocoabeans.commands.lexer.SimpleKeywordToken;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.37")
public class SimpleCommandLexer
implements CommandLexer {
    private final CommandTokenSupplier<ArgumentParserToken> argumentSupplier;
    private final CommandTokenSupplier<KeywordToken> keywordSupplier;

    public SimpleCommandLexer() {
        this(SimpleArgumentParserToken::new, SimpleKeywordToken::new);
    }

    public SimpleCommandLexer(CommandTokenSupplier<ArgumentParserToken> argumentSupplier, CommandTokenSupplier<KeywordToken> keywordSupplier) {
        this.argumentSupplier = argumentSupplier;
        this.keywordSupplier = keywordSupplier;
    }

    @Override
    public List<CommandToken> tokenize(String command) {
        ArrayList<CommandToken> tokens = new ArrayList<CommandToken>();
        int from = 0;
        boolean hasData = false;
        boolean argumentParser = false;
        for (int i = 0; i < command.length(); ++i) {
            char c = command.charAt(i);
            if (c == ' ') {
                if (argumentParser) continue;
                this.handleKeyword(tokens, from, i, command);
                from = i + 1;
                hasData = false;
                continue;
            }
            if (c == '<') {
                this.ensureCouldOpenArgument(argumentParser, hasData);
                argumentParser = true;
                continue;
            }
            if (c == '>') {
                this.handleClosingArgument(tokens, from, i, command, argumentParser);
                argumentParser = false;
                from = i + 1;
                hasData = false;
                continue;
            }
            hasData = true;
        }
        if (hasData) {
            this.handleFinalArgument(tokens, from, command, argumentParser);
        }
        return tokens;
    }

    private void ensureCouldOpenArgument(boolean argumentParser, boolean hasData) {
        if (argumentParser) {
            throw new IllegalArgumentException("Nested argument parsers are not allowed");
        }
        if (hasData) {
            throw new IllegalArgumentException("Missing keyword in argument parser");
        }
    }

    private void handleKeyword(List<CommandToken> tokens, int from, int to, String command) {
        if (from == to) {
            return;
        }
        tokens.add(this.keywordSupplier.apply(from, to, command));
    }

    private void handleClosingArgument(List<CommandToken> tokens, int from, int to, String command, boolean argumentParser) {
        if (!argumentParser) {
            throw new IllegalArgumentException("Missing argument parser");
        }
        if (from == to - 1) {
            throw new IllegalArgumentException("Empty argument parser");
        }
        tokens.add(this.argumentSupplier.apply(from, to + 1, command));
    }

    private void handleFinalArgument(List<CommandToken> tokens, int from, String command, boolean argumentParser) {
        if (argumentParser) {
            throw new IllegalArgumentException("Missing argument parser");
        }
        if (from != command.length() - 1) {
            tokens.add(this.keywordSupplier.apply(from, command.length(), command));
        }
    }
}

