/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.collect;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.IntStream;
import net.apartium.cocoabeans.functions.ByteConsumer;
import org.jetbrains.annotations.NotNull;

public class ImmutableByteArrayList {
    private static final ImmutableByteArrayList EMPTY = new ImmutableByteArrayList(new byte[0]);
    final byte[] content;

    public static ImmutableByteArrayList of() {
        return EMPTY;
    }

    public static ImmutableByteArrayList of(byte ... values) {
        byte[] content = Arrays.copyOf(values, values.length);
        return new ImmutableByteArrayList(content);
    }

    public static ImmutableByteArrayList makeBetter(Collection<Byte> c) {
        Byte[] orig = c.toArray(new Byte[0]);
        byte[] content = new byte[c.size()];
        for (int i = 0; i < c.size(); ++i) {
            content[i] = orig[i];
        }
        return new ImmutableByteArrayList(content);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private ImmutableByteArrayList(byte[] content) {
        this.content = content;
    }

    public int size() {
        return this.content.length;
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public boolean contains(byte value) {
        for (byte element : this.content) {
            if (value != element) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Iterator<Byte> iterator() {
        return new Iterator<Byte>(){
            int position = -1;

            @Override
            public boolean hasNext() {
                return this.position + 1 < ImmutableByteArrayList.this.content.length;
            }

            @Override
            public Byte next() {
                return ImmutableByteArrayList.this.content[++this.position];
            }
        };
    }

    public void forEach(ByteConsumer consumer) {
        for (byte val : this.content) {
            consumer.accept(val);
        }
    }

    public IntStream stream() {
        IntStream.Builder builder = IntStream.builder();
        this.forEach(builder::add);
        return builder.build();
    }

    @JsonValue
    public byte[] toArray() {
        return Arrays.copyOf(this.content, this.content.length);
    }

    public byte get(int index) {
        return this.content[index];
    }

    public int indexOf(byte value) {
        for (int i = 0; i < this.content.length; ++i) {
            byte val = this.content[i];
            if (val != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte value) {
        int result = -1;
        for (int i = 0; i < this.content.length; ++i) {
            byte val = this.content[i];
            if (val != value) continue;
            result = i;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableByteArrayList that = (ImmutableByteArrayList)o;
        return Arrays.equals(this.content, that.content);
    }

    public int hashCode() {
        return Arrays.hashCode(this.content);
    }

    public String toString() {
        return "ImmutableByteArrayList{content=" + Arrays.toString(this.content) + "}";
    }
}

