/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans;

import java.util.Collection;
import java.util.Map;
import net.apartium.cocoabeans.StringHelpers;
import org.jetbrains.annotations.ApiStatus;

public class Ensures {
    private static final String CANNOT_BE_NULL_MESSAGE = "cannot be null or empty";

    public static void notEmpty(String string, RuntimeException ex) {
        if (ex == null) {
            ex = new NullPointerException();
        }
        if (StringHelpers.isNullOrEmpty(string)) {
            throw ex;
        }
    }

    public static void notNull(Object obj, RuntimeException ex) {
        if (obj == null) {
            throw ex == null ? new NullPointerException() : ex;
        }
    }

    public static void notEmpty(Collection<?> collection, RuntimeException ex) {
        Ensures.notNull(collection, ex);
        if (collection.isEmpty()) {
            throw ex;
        }
    }

    public static void notEmpty(Collection<?> collection, String message) {
        Ensures.notEmpty(collection, (RuntimeException)new NullPointerException(message.replace("\\+-", CANNOT_BE_NULL_MESSAGE)));
    }

    public static void notEmpty(Map<?, ?> map, RuntimeException ex) {
        Ensures.notNull((Object)ex, "ex +-");
        Ensures.notNull(map, ex);
        if (map.isEmpty()) {
            throw ex;
        }
    }

    public static void notEmpty(Map<?, ?> map, String message) {
        Ensures.notEmpty(map, new RuntimeException(message.replace("\\+-", CANNOT_BE_NULL_MESSAGE)));
    }

    public static void notEmpty(Object[] array, RuntimeException ex) {
        Ensures.notNull((Object)array, ex);
        if (array.length == 0) {
            throw ex;
        }
    }

    public static void notEmpty(Object[] array, String message) {
        Ensures.notEmpty(array, new RuntimeException(message.replace("\\+-", CANNOT_BE_NULL_MESSAGE)));
    }

    public static void notNull(Object obj, String message) {
        Ensures.notNull(obj, new NullPointerException(message.replace("\\+-", "cannot be null")));
    }

    public static void notEmpty(String string, String message) {
        Ensures.notEmpty(string, new RuntimeException(message.replace("\\+-", "cannot be empty / null")));
    }

    public static void largerThan(int num1, int num2, RuntimeException ex) {
        if (num1 < num2 && ex != null) {
            throw ex;
        }
    }

    public static void largerThan(int num1, int num2, String message) {
        Ensures.largerThan(num1, num2, new RuntimeException(message.replace("\\+-", "must be larger than")));
    }

    public static void isTrue(boolean bool) {
        Ensures.isTrue(bool, new RuntimeException());
    }

    public static void isTrue(boolean bool, String message) {
        message = message.replace("\\+-", "must be true");
        Ensures.isTrue(bool, new NullPointerException(message));
    }

    public static void isTrue(boolean bool, RuntimeException ex) {
        if (!bool) {
            throw ex == null ? new RuntimeException() : ex;
        }
    }

    @ApiStatus.AvailableSince(value="0.0.40")
    public static void isFalse(boolean bool, RuntimeException ex) {
        if (bool) {
            throw ex == null ? new RuntimeException() : ex;
        }
    }

    @ApiStatus.AvailableSince(value="0.0.40")
    public static void isFalse(boolean bool) {
        Ensures.isFalse(bool, new RuntimeException());
    }

    @ApiStatus.AvailableSince(value="0.0.40")
    public static void isFalse(boolean bool, String message) {
        message = message.replace("\\+-", "must be false");
        Ensures.isFalse(bool, new RuntimeException(message));
    }
}

