/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.utils;

public class CallerUtils {
    private static final Impl impl = CallerUtils.getImplementation();

    private static Impl getImplementation() {
        try {
            Class.forName("java.lang.StackWalker");
            return new StackWalkerImpl();
        }
        catch (Exception e) {
            return new LegacyImpl();
        }
    }

    public static Class<?> getCallerClassExcept(Class<?> clazz) {
        return impl.getCallerClassExcept(clazz);
    }

    public static String getCallerClassNameExcept(Class<?> clazz) {
        return impl.getCallerClassNameExpect(clazz);
    }

    private static class StackWalkerImpl
    implements Impl {
        private static final StackWalker WALKER_WITH_CLASS_REF = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

        private StackWalkerImpl() {
        }

        @Override
        public Class<?> getCallerClassExcept(Class<?> clazz) {
            return WALKER_WITH_CLASS_REF.walk(stream -> stream.map(StackWalker.StackFrame::getDeclaringClass).filter(cls -> !cls.equals(clazz) && !cls.equals(CallerUtils.class) && !cls.equals(StackWalkerImpl.class)).findFirst()).orElse(null);
        }

        @Override
        public String getCallerClassNameExpect(Class<?> clazz) {
            return StackWalker.getInstance().walk(stream -> stream.map(StackWalker.StackFrame::getClassName).filter(cls -> (clazz == null || !cls.equals(clazz.getName())) && !cls.equals(CallerUtils.class.getName()) && !cls.equals(StackWalkerImpl.class.getName())).findFirst()).orElse(null);
        }
    }

    private static class LegacyImpl
    implements Impl {
        private LegacyImpl() {
        }

        @Override
        public Class<?> getCallerClassExcept(Class<?> clazz) {
            try {
                return Class.forName(this.getCallerClassNameExpect(clazz));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public String getCallerClassNameExpect(Class<?> clazz) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            String className = clazz.getName();
            boolean classFound = false;
            for (int i = 2; i < stackTrace.length; ++i) {
                StackTraceElement element = stackTrace[i];
                String callerClassName = element.getClassName();
                if (callerClassName.equals(className)) {
                    classFound = true;
                    continue;
                }
                if (!classFound) continue;
                return callerClassName;
            }
            return null;
        }
    }

    private static interface Impl {
        public Class<?> getCallerClassExcept(Class<?> var1);

        public String getCallerClassNameExpect(Class<?> var1);
    }
}

