/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.tab;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.apartium.cocoabeans.scoreboard.ViewerGroup;
import net.apartium.cocoabeans.state.LazyWatcher;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.structs.Entry;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.41")
public abstract class TabList<P> {
    protected final ViewerGroup<P> group;
    protected final LazyWatcher<Set<P>> groupWatcher;
    private final LazyWatcher<Component> header = Observable.empty().lazyWatch();
    private final LazyWatcher<Component> footer = Observable.empty().lazyWatch();

    protected TabList(ViewerGroup<P> group) {
        this.group = group;
        this.groupWatcher = group.observePlayers().lazyWatch();
    }

    protected Set<P> currentViewers() {
        return Optional.ofNullable(this.groupWatcher.getLastValue()).orElse(Set.of());
    }

    protected boolean isDirty() {
        return this.header.isDirty() || this.footer.isDirty();
    }

    public void heartbeat() {
        if (this.isDirty()) {
            Entry<Component, Boolean> newHeader = this.header.getOrUpdate();
            Entry<Component, Boolean> newFooter = this.footer.getOrUpdate();
            if (newHeader.value().booleanValue() || newFooter.value().booleanValue()) {
                this.sendPlayerListHeaderAndFooter(this.currentViewers(), newHeader.key(), newFooter.key());
            }
        }
        this.heartbeatViewers();
    }

    private void heartbeatViewers() {
        if (!this.groupWatcher.isDirty()) {
            return;
        }
        Set cache = Optional.ofNullable(this.groupWatcher.getLastValue()).orElse(Set.of());
        Entry<Set<P>, Boolean> entry = this.groupWatcher.getOrUpdate();
        if (Boolean.FALSE.equals(entry.value())) {
            return;
        }
        HashSet toAdd = new HashSet(entry.key());
        toAdd.removeAll(cache);
        HashSet toRemove = new HashSet(cache);
        toRemove.removeAll((Collection)entry.key());
        this.sendPlayerListHeaderAndFooter(toAdd, this.header.getLastValue(), this.footer.getLastValue());
        this.sendPlayerListHeaderAndFooter(toRemove, null, null);
    }

    public ViewerGroup<P> getViewers() {
        return this.group;
    }

    public void set(Component header, Component footer) {
        this.header(header);
        this.footer(footer);
    }

    public void set(Observable<Component> header, Observable<Component> footer) {
        this.header(header);
        this.footer(footer);
    }

    public void header(Component header) {
        this.header(Observable.immutable(header));
    }

    public void header(Observable<Component> header) {
        this.header.setDependsOn(header);
    }

    public void footer(Component footer) {
        this.footer(Observable.immutable(footer));
    }

    public void footer(Observable<Component> footer) {
        this.footer.setDependsOn(footer);
    }

    public void delete() {
        this.sendPlayerListHeaderAndFooter(this.currentViewers(), null, null);
        this.header.delete();
        this.footer.delete();
    }

    protected abstract void sendPlayerListHeaderAndFooter(Set<P> var1, Component var2, Component var3);
}

