/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.state.spigot;

import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import net.apartium.cocoabeans.state.MutableObservable;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.state.SetObservable;
import net.apartium.cocoabeans.state.spigot.listeners.PlayerJoinListener;
import net.apartium.cocoabeans.state.spigot.listeners.PlayerQuitListener;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class SpigotProvidedState {
    private final JavaPlugin plugin;
    private BukkitTask cprTask = null;
    private PlayerJoinListener playerJoinListener;
    private PlayerQuitListener playerQuitListener;
    private SetObservable<Player> onlinePlayers;
    private MutableObservable<Integer> currentTick;
    private MutableObservable<Instant> now;

    public SpigotProvidedState(JavaPlugin plugin) {
        this.plugin = plugin;
        this.onlinePlayers = Observable.set(new HashSet<Player>(this.getOnlinePlayers()));
        this.currentTick = Observable.mutable(0);
        this.now = Observable.mutable(Instant.now());
        this.playerQuitListener = new PlayerQuitListener(this.onlinePlayers);
        this.playerJoinListener = new PlayerJoinListener(this.onlinePlayers);
        Bukkit.getPluginManager().registerEvents((Listener)this.playerQuitListener, (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this.playerJoinListener, (Plugin)plugin);
    }

    public void heartbeat() {
        this.currentTick.set((Integer)this.currentTick.get() + 1);
        this.now.set(Instant.now());
    }

    public void startCprTask() {
        if (this.cprTask != null) {
            this.cprTask.cancel();
            this.cprTask = null;
        }
        this.cprTask = new BukkitRunnable(){

            public void run() {
                SpigotProvidedState.this.heartbeat();
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    private Set<Player> getOnlinePlayers() {
        Set<Player> players = Collections.newSetFromMap(new WeakHashMap());
        players.addAll(Bukkit.getOnlinePlayers());
        return players;
    }

    public Observable<Set<Player>> getOnlinePlayersObservable() {
        return this.onlinePlayers;
    }

    public Observable<Integer> currentTickObservable() {
        return this.currentTick;
    }

    public Observable<Instant> getNow() {
        return this.now;
    }

    public void remove() {
        if (this.cprTask != null) {
            this.cprTask.cancel();
            this.cprTask = null;
        }
        if (this.playerQuitListener != null) {
            HandlerList.unregisterAll((Listener)this.playerQuitListener);
        }
        this.playerQuitListener = null;
        if (this.playerJoinListener != null) {
            HandlerList.unregisterAll((Listener)this.playerJoinListener);
        }
        this.playerJoinListener = null;
        this.onlinePlayers.clear();
        this.onlinePlayers = null;
        this.currentTick = null;
    }
}

