/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.apartium.cocoabeans.CollectionHelpers;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.state.Observer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ObservableCompound<T>
implements Observable<T>,
Observer {
    private final Set<Observer> observers = Collections.newSetFromMap(new WeakHashMap());
    private boolean isDirty = false;
    private boolean first = true;
    private final Map<Observable<?>, Object> dependsOn = new LinkedHashMap();
    private final Function<List<?>, T> singularMapper;
    private T cachedValue;

    public ObservableCompound(Function<List<?>, T> singularMapper, List<Observable<?>> list) {
        this.singularMapper = singularMapper;
        for (Observable<?> state : list) {
            this.dependsOn.put(state, null);
            state.observe(this);
        }
    }

    @Override
    public T get() {
        if (!this.isDirty && !this.first) {
            return this.cachedValue;
        }
        boolean hadChange = false;
        ArrayList values = new ArrayList(this.dependsOn.size());
        for (Map.Entry<Observable<?>, Object> entry : this.dependsOn.entrySet()) {
            Object obj = entry.getKey().get();
            values.add(obj);
            if (Objects.equals(obj, entry.getValue())) continue;
            if (!(obj instanceof Collection)) {
                hadChange = true;
                this.dependsOn.put(entry.getKey(), obj);
                continue;
            }
            Collection collection = (Collection)obj;
            if (CollectionHelpers.equalsCollections(collection, (Collection)entry.getValue())) continue;
            hadChange = true;
            this.dependsOn.put(entry.getKey(), obj);
        }
        if (!this.first && !hadChange) {
            this.isDirty = false;
            return this.cachedValue;
        }
        this.first = false;
        this.isDirty = false;
        T temp = this.singularMapper.apply(Collections.unmodifiableList(values));
        boolean hasChange = !Objects.equals(temp, this.cachedValue);
        this.cachedValue = temp;
        if (hasChange) {
            for (Observer observer : this.observers) {
                observer.flagAsDirty(this);
            }
        }
        return this.cachedValue;
    }

    @Override
    public void observe(Observer observer) {
        this.observers.add(observer);
    }

    @Override
    public boolean removeObserver(Observer observer) {
        return this.observers.remove(observer);
    }

    @Override
    public void flagAsDirty(Observable<?> observable) {
        if (!this.dependsOn.containsKey(observable)) {
            return;
        }
        this.isDirty = true;
        for (Observer observer : this.observers) {
            observer.flagAsDirty(this);
        }
    }
}

