/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot.visibility;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import net.apartium.cocoabeans.spigot.VersionedImplInstantiator;
import net.apartium.cocoabeans.spigot.visibility.PlayerVisibilityController;
import net.apartium.cocoabeans.spigot.visibility.VisibilityGroup;
import net.apartium.cocoabeans.spigot.visibility.VisibilityListener;
import net.apartium.cocoabeans.spigot.visibility.VisibilityPlayer;
import net.apartium.cocoabeans.spigot.visibility.VisibilityPlayerRemoveType;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VisibilityManager {
    private final Map<String, VisibilityGroup> groups = new HashMap<String, VisibilityGroup>();
    private final Map<UUID, VisibilityPlayer> players = new HashMap<UUID, VisibilityPlayer>();
    private final PlayerVisibilityController playerVisibilityController;
    private final JavaPlugin plugin;
    private VisibilityListener visibilityListener;

    public VisibilityManager(JavaPlugin plugin) {
        this(plugin, VersionedImplInstantiator.createPlayerVisibilityController());
    }

    public VisibilityManager(JavaPlugin plugin, PlayerVisibilityController playerVisibilityController) {
        this.plugin = plugin;
        this.playerVisibilityController = playerVisibilityController;
    }

    public void registerListener(VisibilityPlayerRemoveType removeType) {
        if (this.visibilityListener != null) {
            return;
        }
        this.visibilityListener = new VisibilityListener(this, removeType);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.visibilityListener, (Plugin)this.plugin);
    }

    public void registerListener() {
        this.registerListener(VisibilityPlayerRemoveType.ON_LEAVE);
    }

    public void unregisterListener() {
        if (this.visibilityListener == null) {
            return;
        }
        HandlerList.unregisterAll((Listener)this.visibilityListener);
        this.visibilityListener = null;
    }

    public void reloadVisibility() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.updateVisiblityForPlayer(player);
        }
    }

    public void handlePlayerJoin(Player joinPlayer) {
        VisibilityPlayer visibilityPlayer = this.getPlayer(joinPlayer);
        if (visibilityPlayer.getVisibleGroups().isEmpty()) {
            for (Player target : this.plugin.getServer().getOnlinePlayers()) {
                if (target == joinPlayer) continue;
                if (this.getPlayer(target).getVisibleGroups().isEmpty()) {
                    this.playerVisibilityController.showPlayer(this.plugin, target, joinPlayer);
                    continue;
                }
                this.playerVisibilityController.hidePlayer(this.plugin, joinPlayer, target);
                this.playerVisibilityController.hidePlayer(this.plugin, target, joinPlayer);
            }
            return;
        }
        for (Player target : this.plugin.getServer().getOnlinePlayers()) {
            if (target == joinPlayer || this.getPlayer(target).getVisibleGroups().isEmpty()) continue;
            this.playerVisibilityController.hidePlayer(this.plugin, target, joinPlayer);
        }
        this.updateVisiblityForPlayer(joinPlayer);
        HashSet<Player> playerToShow = new HashSet<Player>();
        for (VisibilityGroup visibilityGroup : this.groups.values()) {
            boolean playerInHiddenGroup;
            boolean playerInGroup = visibilityGroup.hasPlayer(joinPlayer);
            boolean playerInVisibleGroup = visibilityGroup.getVisibleGroups().stream().anyMatch(group -> group.hasPlayer(joinPlayer));
            if (!playerInGroup && !playerInVisibleGroup || (playerInHiddenGroup = visibilityGroup.getHiddenGroups().stream().anyMatch(group -> group.hasPlayer(joinPlayer)))) continue;
            for (VisibilityPlayer player : visibilityGroup.getPlayers()) {
                Player targetPlayer = player.getPlayer().orElse(null);
                if (targetPlayer == null || targetPlayer == joinPlayer) continue;
                playerToShow.add(targetPlayer);
            }
        }
        for (Player target : playerToShow) {
            this.playerVisibilityController.showPlayer(this.plugin, target, joinPlayer);
        }
    }

    public VisibilityPlayer getPlayer(UUID uuid) {
        return this.players.computeIfAbsent(uuid, key -> new VisibilityPlayer(this, uuid));
    }

    public VisibilityPlayer getPlayer(Player player) {
        return this.players.computeIfAbsent(player.getUniqueId(), key -> new VisibilityPlayer(this, player));
    }

    public void removePlayer(UUID uuid) {
        VisibilityPlayer remove = this.players.remove(uuid);
        if (remove == null) {
            return;
        }
        for (VisibilityGroup group : remove.getVisibleGroups()) {
            group.removePlayer(remove);
        }
    }

    void updateVisiblityForPlayer(Player player) {
        VisibilityPlayer visibilityPlayer = this.getPlayer(player);
        if (visibilityPlayer.getVisibleGroups().isEmpty()) {
            for (Player target : this.plugin.getServer().getOnlinePlayers()) {
                if (target == player) continue;
                if (!this.getPlayer(target).getVisibleGroups().isEmpty()) {
                    this.playerVisibilityController.hidePlayer(this.plugin, player, target);
                    this.playerVisibilityController.hidePlayer(this.plugin, target, player);
                    continue;
                }
                this.playerVisibilityController.showPlayer(this.plugin, player, target);
                this.playerVisibilityController.showPlayer(this.plugin, target, player);
            }
            return;
        }
        for (Player target : this.plugin.getServer().getOnlinePlayers()) {
            if (target == player) continue;
            if (this.getPlayer(target).getVisibleGroups().isEmpty()) {
                this.playerVisibilityController.hidePlayer(this.plugin, player, target);
                this.playerVisibilityController.hidePlayer(this.plugin, target, player);
                continue;
            }
            this.playerVisibilityController.hidePlayer(this.plugin, player, target);
        }
        HashSet<Player> playersToShow = new HashSet<Player>();
        for (VisibilityGroup group : visibilityPlayer.getVisibleGroups()) {
            if (!group.hasPlayer(player)) continue;
            for (VisibilityGroup targetGroup2 : group.getVisibleGroups()) {
                for (VisibilityPlayer target : targetGroup2.getPlayers()) {
                    Player targetPlayer = target.getPlayer().orElse(null);
                    if (targetPlayer == null || player == targetPlayer || playersToShow.contains(targetPlayer) || group.getHiddenGroups().stream().anyMatch(tg -> tg.hasPlayer(targetPlayer))) continue;
                    playersToShow.add(targetPlayer);
                }
            }
            for (VisibilityPlayer target : group.getPlayers()) {
                Player targetPlayer = target.getPlayer().orElse(null);
                if (targetPlayer == null || player == targetPlayer || playersToShow.contains(targetPlayer) || group.getHiddenGroups().stream().anyMatch(targetGroup -> targetGroup.hasPlayer(targetPlayer))) continue;
                playersToShow.add(targetPlayer);
            }
        }
        for (Player target : playersToShow) {
            this.playerVisibilityController.showPlayer(this.plugin, player, target);
        }
    }

    public VisibilityGroup getOrCreateGroup(String name) {
        return this.groups.computeIfAbsent(name, n -> new VisibilityGroup(this, (String)n));
    }

    public boolean deleteGroup(String name) {
        VisibilityGroup remove = this.groups.remove(name);
        if (remove == null) {
            return false;
        }
        if (remove.getPlayers().isEmpty()) {
            return true;
        }
        for (VisibilityPlayer visibilityPlayer : this.players.values()) {
            visibilityPlayer.removeVisibleGroup(remove);
            Player player = visibilityPlayer.getPlayer().orElse(null);
            if (player == null) continue;
            this.updateVisiblityForPlayer(player);
        }
        return true;
    }

    public boolean canSee(Player player, Player target) {
        VisibilityPlayer visibilityPlayer = this.getPlayer(player);
        VisibilityPlayer visibilityTarget = this.getPlayer(target);
        if (visibilityPlayer.getVisibleGroups().isEmpty() && visibilityTarget.getVisibleGroups().isEmpty()) {
            return true;
        }
        if (visibilityPlayer.getVisibleGroups().isEmpty() || visibilityTarget.getVisibleGroups().isEmpty()) {
            return false;
        }
        for (VisibilityGroup group : visibilityPlayer.getVisibleGroups()) {
            if (!group.hasPlayer(target) && group.getVisibleGroups().stream().noneMatch(targetGroup -> targetGroup.hasPlayer(target)) || group.getHiddenGroups().stream().anyMatch(targetGroup -> targetGroup.hasPlayer(target))) continue;
            return true;
        }
        return false;
    }

    public Collection<VisibilityGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public Stream<VisibilityPlayer> getPlayers() {
        return this.players.values().stream();
    }
}

