/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot.scoreboard;

import java.util.Set;
import net.apartium.cocoabeans.scoreboard.DisplaySlot;
import net.apartium.cocoabeans.scoreboard.ObjectiveMode;
import net.apartium.cocoabeans.scoreboard.ScoreboardAction;
import net.apartium.cocoabeans.scoreboard.ScoreboardNumericDisplay;
import net.apartium.cocoabeans.scoreboard.ViewerGroup;
import net.apartium.cocoabeans.spigot.scoreboard.NMSUtils;
import net.apartium.cocoabeans.state.Observable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import org.bukkit.entity.Player;

public class SpigotScoreboardNumericDisplay
extends ScoreboardNumericDisplay<Player> {
    public SpigotScoreboardNumericDisplay(String objectiveId, ViewerGroup<Player> group, Observable<Component> displayName) {
        super(objectiveId, group, displayName);
    }

    @Override
    public void sendDisplayPacket(Set<Player> audience, DisplaySlot slot, String objectiveId) {
        if (audience.isEmpty()) {
            return;
        }
        try {
            Object packet = NMSUtils.createDisplayPacket(objectiveId, slot);
            for (Player player : audience) {
                NMSUtils.sendPacket(player, packet);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendScorePacket(Set<Player> audience, String entity, int score, ScoreboardAction action, Component fixedContent, Style numberStyle) {
        if (audience.isEmpty()) {
            return;
        }
        try {
            Object packet = NMSUtils.createScorePacket(entity, this.objectiveId, fixedContent, score, action, numberStyle);
            for (Player player : audience) {
                NMSUtils.sendPacket(player, packet);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendObjectivePacket(Set<Player> audience, ObjectiveMode mode, Component displayName) {
        if (audience.isEmpty()) {
            return;
        }
        try {
            Object packet = NMSUtils.createObjectivePacket(this.objectiveId, mode, this.renderType, displayName);
            for (Player player : audience) {
                NMSUtils.sendPacket(player, packet);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

