/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot.scoreboard;

import net.apartium.cocoabeans.scoreboard.CocoaBoard;
import net.apartium.cocoabeans.scoreboard.TeamMode;
import net.apartium.cocoabeans.spigot.ServerUtils;
import net.apartium.cocoabeans.spigot.scoreboard.SpigotCocoaBoard;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.structs.MinecraftVersion;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SpigotCocoaBoard_1_8_R1
extends SpigotCocoaBoard {
    private static final boolean HAS_LINES_MAX_LENGTH = !ServerUtils.getVersion().isHigherThanOrEqual(MinecraftVersion.V1_13);
    private static final int OLD_MAX = 16;
    private static final int NEW_MAX = 1024;
    private static final int MAX_LENGTH = HAS_LINES_MAX_LENGTH ? 16 : 1024;

    public SpigotCocoaBoard_1_8_R1(Player player, String objectiveId, Observable<Component> title) {
        super(player, objectiveId, title);
        this.createBoardAndDisplay();
    }

    @Override
    protected void sendLineChange(int score, CocoaBoard.ComponentEntry entry, TeamMode mode) {
        Object prefix;
        String line = entry.component() != null && entry.component().get() != null ? LegacyComponentSerializer.legacySection().serialize(entry.component().get()) : "";
        Object suffix = "";
        if (line.isEmpty()) {
            prefix = COLOR_CODES[score] + String.valueOf(ChatColor.RESET);
        } else if (line.length() <= MAX_LENGTH) {
            prefix = line;
        } else {
            int index = line.charAt(MAX_LENGTH - 1) == '\u00a7' ? MAX_LENGTH - 1 : MAX_LENGTH;
            prefix = line.substring(0, index);
            String suffixTmp = line.substring(index);
            suffix = this.addColor((String)prefix, this.chatColorForSuffix(suffixTmp)) + suffixTmp;
        }
        if (((String)prefix).length() > MAX_LENGTH || ((String)suffix).length() > MAX_LENGTH) {
            prefix = ((String)prefix).substring(0, Math.min(MAX_LENGTH, ((String)prefix).length()));
            suffix = ((String)suffix).substring(0, Math.min(MAX_LENGTH, ((String)suffix).length()));
        }
        this.sendTeamPacket(score, mode, SpigotCocoaBoard_1_8_R1.toObservable((Component)Component.text((String)prefix)), SpigotCocoaBoard_1_8_R1.toObservable((Component)Component.text((String)suffix)));
    }

    private String addColor(String prefix, ChatColor chatColor) {
        String color = ChatColor.getLastColors((String)prefix);
        if (chatColor == null || chatColor.isFormat()) {
            return color.isEmpty() ? ChatColor.RESET.toString() : color;
        }
        return "";
    }

    private ChatColor chatColorForSuffix(String suffix) {
        if (suffix.length() >= 2 && suffix.charAt(0) == '\u00a7') {
            return ChatColor.getByChar((char)suffix.charAt(1));
        }
        return null;
    }
}

