/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot.scoreboard;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import net.apartium.cocoabeans.scoreboard.CocoaBoard;
import net.apartium.cocoabeans.scoreboard.DisplaySlot;
import net.apartium.cocoabeans.scoreboard.ObjectiveMode;
import net.apartium.cocoabeans.scoreboard.ObjectiveRenderType;
import net.apartium.cocoabeans.scoreboard.ScoreboardAction;
import net.apartium.cocoabeans.scoreboard.TeamMode;
import net.apartium.cocoabeans.spigot.scoreboard.CocoaBoardInstantiator;
import net.apartium.cocoabeans.spigot.scoreboard.NMSUtils;
import net.apartium.cocoabeans.spigot.scoreboard.SpigotCocoaBoardFactory;
import net.apartium.cocoabeans.state.Observable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.39")
public abstract class SpigotCocoaBoard
extends CocoaBoard {
    private static final SpigotCocoaBoardFactory factory = CocoaBoardInstantiator.createCocoaBoardFactory();
    protected static final String[] COLOR_CODES = (String[])Arrays.stream(ChatColor.values()).map(Object::toString).toArray(String[]::new);
    private WeakReference<Player> player;
    protected final UUID playerUUID;

    public static SpigotCocoaBoard create(Player player, String objectiveId, Observable<Component> title) {
        return factory.create(player, objectiveId, title);
    }

    public static SpigotCocoaBoard create(Player player, String objectiveId, Component title) {
        return factory.create(player, objectiveId, title);
    }

    public static SpigotCocoaBoard create(Player player, String objectiveId) {
        return factory.create(player, objectiveId);
    }

    public static SpigotCocoaBoard create(Player player, Observable<Component> title) {
        return factory.create(player, title);
    }

    public static SpigotCocoaBoard create(Player player, Component title) {
        return factory.create(player, title);
    }

    public static SpigotCocoaBoard create(Player player) {
        return factory.create(player);
    }

    protected SpigotCocoaBoard(Player player, String objectiveId, Observable<Component> title) {
        super(objectiveId, title, NMSUtils.isCustomScoreSupported());
        this.playerUUID = player.getUniqueId();
        this.player = new WeakReference<Player>(player);
    }

    public Player getPlayer() {
        Player target = (Player)this.player.get();
        if (target == null) {
            target = Bukkit.getPlayer((UUID)this.playerUUID);
            if (target == null) {
                return null;
            }
            this.player = new WeakReference<Player>(target);
        }
        return target;
    }

    @Override
    protected void sendObjectivePacket(ObjectiveMode mode, Observable<Component> displayName) {
        try {
            NMSUtils.sendPacket(this.getPlayer(), NMSUtils.createObjectivePacket(this.objectiveId, mode, ObjectiveRenderType.INTEGER, Optional.ofNullable(displayName).map(Observable::get).orElse(null)));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void sendDisplayPacket() {
        try {
            NMSUtils.sendPacket(this.getPlayer(), NMSUtils.createDisplayPacket(this.objectiveId, DisplaySlot.SIDEBAR));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void sendScorePacket(int score, Observable<Component> displayName, ScoreboardAction action, Style numberStyle) {
        try {
            NMSUtils.sendPacket(this.getPlayer(), NMSUtils.createScorePacket(COLOR_CODES[score], this.objectiveId, Optional.ofNullable(displayName).map(Observable::get).orElse(null), score, action, numberStyle));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void sendTeamPacket(int score, TeamMode mode, Observable<Component> prefix, Observable<Component> suffix) {
        try {
            NMSUtils.sendPacket(this.getPlayer(), NMSUtils.createTeamPacket(this.intoTeamName(score), mode, Optional.ofNullable(prefix).map(Observable::get).orElse(null), Optional.ofNullable(suffix).map(Observable::get).orElse(null), mode == TeamMode.CREATE ? Collections.singleton(COLOR_CODES[score]) : Collections.emptyList()));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

