/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot.scoreboard;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.apartium.cocoabeans.scoreboard.DisplaySlot;
import net.apartium.cocoabeans.scoreboard.ObjectiveMode;
import net.apartium.cocoabeans.scoreboard.ObjectiveRenderType;
import net.apartium.cocoabeans.scoreboard.ScoreboardAction;
import net.apartium.cocoabeans.scoreboard.TeamMode;
import net.apartium.cocoabeans.scoreboard.team.ChatFormatting;
import net.apartium.cocoabeans.scoreboard.team.CollisionRule;
import net.apartium.cocoabeans.scoreboard.team.NameTagVisibilityRule;
import net.apartium.cocoabeans.spigot.ServerUtils;
import net.apartium.cocoabeans.structs.MinecraftVersion;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

class NMSUtils {
    private static final Map<Class<?>, Field[]> PACKETS = new HashMap(16);
    private static final String OBC_PACKAGE = Bukkit.getServer().getClass().getPackage().getName();
    private static final String NM_PACKAGE = "net.minecraft";
    private static final String NMS_PACKAGE = OBC_PACKAGE.replace("org.bukkit.craftbukkit", "net.minecraft.server");
    private static final boolean NMS_REPACKAGED = NMSUtils.optionalForName("net.minecraft.network.protocol.Packet").isPresent();
    private static final boolean MOJANG_MAPPING = NMSUtils.optionalForName("net.minecraft.network.chat.Component").isPresent();
    private static final MinecraftVersion VERSION = ServerUtils.getVersion();
    private static final MethodType VOID_METHOD_TYPE = MethodType.methodType(Void.TYPE);
    private static final MethodHandle PLAYER_GET_HANDLE;
    private static final MethodHandle PLAYER_CONNECTION;
    private static final MethodHandle PLAYER_SEND_PACKET;
    private static final PacketConstructor PACKET_SB_UPDATE_OBJ;
    private static final PacketConstructor PACKET_SB_DISPLAY_OBJ;
    private static final PacketConstructor PACKET_SB_TEAM;
    private static final PacketConstructor PACKET_SB_SERIALIZABLE_TEAM;
    private static final MethodHandle PACKET_SB_UPDATE_SCORE;
    private static final MethodHandle PACKET_SB_RESET_SCORE;
    private static final MethodHandle FIXED_NUMBER_FORMAT;
    private static final MethodHandle STYLE_NUMBER_FORMAT;
    private static final Object BLANK_NUMBER_FORMAT;
    private static final Object EMPTY_STYLE;
    private static final MethodHandle STYLE_METHOD_WITH_COLOR_RGB;
    private static final MethodHandle STYLE_METHOD_WITH_BOLD;
    private static final MethodHandle STYLE_METHOD_WITH_ITALIC;
    private static final MethodHandle STYLE_METHOD_WITH_UNDERLINE;
    private static final MethodHandle STYLE_METHOD_WITH_STRIKETHROUGH;
    private static final MethodHandle STYLE_METHOD_WITH_OBFUSCATED;
    private static final Class<?> CHAT_FORMAT_ENUM;
    private static volatile Object unsafeObject;
    public static final Class<?> DISPLAY_SLOT_TYPE;
    public static final Map<DisplaySlot, Object> DISPLAY_SLOT_OBJECT_MAP;
    public static final Class<?> CHAT_COMPONENT_CLASS;
    public static final Class<?> RENDER_TYPE;
    public static final Map<ObjectiveRenderType, Object> RENDER_TYPE_OBJECT_MAP;
    private static final Class<?> ENUM_SB_ACTION;
    private static final Class<?> ENUM_VISIBILITY;
    private static final Class<?> ENUM_COLLISION_RULE;
    private static final Object ENUM_SB_ACTION_CHANGE;
    private static final Object ENUM_SB_ACTION_REMOVE;
    private static final Object ENUM_VISIBILITY_ALWAYS;
    private static final Object ENUM_COLLISION_RULE_ALWAYS;
    private static final MethodHandle COMPONENT_METHOD;
    private static final Object EMPTY_COMPONENT;
    private static final boolean ADVENTURE_SUPPORT;
    private static final boolean SCORE_OPTIONAL_COMPONENTS;
    public static final String MODE_ALWAYS = "always";
    public static final String MODE_NEVER = "never";

    NMSUtils() {
    }

    public static String getNMSClassName(String newPackage, String className) {
        if (NMS_REPACKAGED) {
            return (String)(newPackage == null ? NM_PACKAGE : "net.minecraft." + newPackage) + "." + className;
        }
        return NMS_PACKAGE + "." + className;
    }

    public static Optional<Class<?>> findNMSClass(String newPackage, String className) {
        return NMSUtils.optionalForName(NMSUtils.getNMSClassName(newPackage, className));
    }

    public static Optional<Class<?>> findNMSClass(String newPackage, String spigotClass, String mojangClass) {
        return NMSUtils.findNMSClass(newPackage, MOJANG_MAPPING ? mojangClass : spigotClass);
    }

    public static String getOBCClassName(String className) {
        return OBC_PACKAGE + "." + className;
    }

    public static Optional<Class<?>> findOBCClass(String className) {
        return NMSUtils.optionalForName(NMSUtils.getOBCClassName(className));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static PacketConstructor findPacketConstructor(Class<?> packetClass, MethodHandles.Lookup lookup) throws Exception {
        try {
            MethodHandle constructor2 = lookup.findConstructor(packetClass, VOID_METHOD_TYPE);
            return (PacketConstructor)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invoke(), ()Ljava/lang/Object;)((MethodHandle)constructor2);
        }
        catch (IllegalAccessException | NoSuchMethodException constructor2) {
            if (unsafeObject == null) {
                Class<NMSUtils> constructor2 = NMSUtils.class;
                // MONITORENTER : net.apartium.cocoabeans.spigot.scoreboard.NMSUtils.class
                if (unsafeObject == null) {
                    Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                    Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
                    unsafeField.setAccessible(true);
                    unsafeObject = unsafeField.get(null);
                }
                // MONITOREXIT : constructor2
            }
            MethodType allocateMethodType = MethodType.methodType(Object.class, Class.class);
            MethodHandle allocateMethod = lookup.findVirtual(unsafeObject.getClass(), "allocateInstance", allocateMethodType);
            return () -> allocateMethod.invoke(unsafeObject, packetClass);
        }
    }

    public static Object findEnumValueOf(Class<?> enumClass, String enumName, int fallbackOrdinal) {
        try {
            return Enum.valueOf(enumClass.asSubclass(Enum.class), enumName);
        }
        catch (IllegalArgumentException e) {
            ?[] values = enumClass.getEnumConstants();
            if (values.length > fallbackOrdinal) {
                return values[fallbackOrdinal];
            }
            throw e;
        }
    }

    public static Optional<Class<?>> optionalForName(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public static Optional<MethodHandle> findConstructor(Class<?> clazz, MethodHandles.Lookup lookup, MethodType type) {
        try {
            return Optional.of(lookup.findConstructor(clazz, type));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    public static Object intoNetworkStyle(Style style) throws Throwable {
        Object newStyle = EMPTY_STYLE;
        TextColor color = style.color();
        if (color != null) {
            newStyle = STYLE_METHOD_WITH_COLOR_RGB.invoke(newStyle, color.value());
        }
        Map decorations = style.decorations();
        newStyle = STYLE_METHOD_WITH_BOLD.invoke(newStyle, NMSUtils.fromState((TextDecoration.State)decorations.get(TextDecoration.BOLD)));
        newStyle = STYLE_METHOD_WITH_ITALIC.invoke(newStyle, NMSUtils.fromState((TextDecoration.State)decorations.get(TextDecoration.ITALIC)));
        newStyle = STYLE_METHOD_WITH_UNDERLINE.invoke(newStyle, NMSUtils.fromState((TextDecoration.State)decorations.get(TextDecoration.UNDERLINED)));
        newStyle = STYLE_METHOD_WITH_STRIKETHROUGH.invoke(newStyle, NMSUtils.fromState((TextDecoration.State)decorations.get(TextDecoration.STRIKETHROUGH)));
        newStyle = STYLE_METHOD_WITH_OBFUSCATED.invoke(newStyle, NMSUtils.fromState((TextDecoration.State)decorations.get(TextDecoration.OBFUSCATED)));
        return newStyle;
    }

    public static Boolean fromState(TextDecoration.State state) {
        if (state == null) {
            return null;
        }
        return switch (state) {
            case TextDecoration.State.TRUE -> true;
            case TextDecoration.State.FALSE -> false;
            default -> null;
        };
    }

    public static Object createObjectivePacket(String id, ObjectiveMode mode, ObjectiveRenderType renderType, Component displayName) throws Throwable {
        Object packet = PACKET_SB_UPDATE_OBJ.createInstance();
        NMSUtils.setField(packet, String.class, id);
        NMSUtils.setField(packet, Integer.TYPE, mode.getId());
        if (mode == ObjectiveMode.REMOVE) {
            return packet;
        }
        NMSUtils.setComponentField(packet, displayName, 1);
        NMSUtils.setField(packet, Optional.class, Optional.empty());
        if (VERSION.isHigherThanOrEqual(MinecraftVersion.V1_8)) {
            NMSUtils.setField(packet, RENDER_TYPE, RENDER_TYPE_OBJECT_MAP.get((Object)renderType));
        }
        return packet;
    }

    public static Object createDisplayPacket(String id, DisplaySlot slot) throws Throwable {
        Object packet = PACKET_SB_DISPLAY_OBJ.createInstance();
        NMSUtils.setField(packet, String.class, Optional.ofNullable(id).orElse(""));
        NMSUtils.setField(packet, DISPLAY_SLOT_TYPE, slot == null ? null : DISPLAY_SLOT_OBJECT_MAP.get((Object)slot));
        return packet;
    }

    public static Object createScorePacket(String entityId, String objectiveId, Component displayName, int scoreValue, ScoreboardAction action, Style numberStyle) throws Throwable {
        if (VERSION.isHigherThanOrEqual(MinecraftVersion.V1_17)) {
            return NMSUtils.createModernScorePacket(entityId, objectiveId, displayName, scoreValue, action, numberStyle);
        }
        Object packet = PACKET_SB_UPDATE_SCORE.invoke();
        NMSUtils.setField(packet, String.class, entityId, 0);
        if (VERSION.isHigherThanOrEqual(MinecraftVersion.V1_8)) {
            NMSUtils.setField(packet, ENUM_SB_ACTION, action == ScoreboardAction.REMOVE ? ENUM_SB_ACTION_REMOVE : ENUM_SB_ACTION_CHANGE);
        } else {
            NMSUtils.setField(packet, Integer.TYPE, action.ordinal(), 1);
        }
        if (action != ScoreboardAction.CREATE_OR_UPDATE) {
            return packet;
        }
        NMSUtils.setField(packet, String.class, objectiveId, 1);
        NMSUtils.setField(packet, Integer.TYPE, scoreValue);
        return packet;
    }

    private static Object createModernScorePacket(String entityId, String objectiveId, Component displayName, int scoreValue, ScoreboardAction action, Style numberStyle) throws Throwable {
        Object enumAction;
        Object object = enumAction = action == ScoreboardAction.REMOVE ? ENUM_SB_ACTION_REMOVE : ENUM_SB_ACTION_CHANGE;
        if (PACKET_SB_RESET_SCORE == null) {
            return PACKET_SB_UPDATE_SCORE.invoke(enumAction, objectiveId, entityId, scoreValue);
        }
        if (action == ScoreboardAction.REMOVE) {
            return PACKET_SB_RESET_SCORE.invoke(entityId, objectiveId);
        }
        Object format = numberStyle == null ? BLANK_NUMBER_FORMAT : STYLE_NUMBER_FORMAT.invoke(NMSUtils.intoNetworkStyle(numberStyle));
        return SCORE_OPTIONAL_COMPONENTS ? PACKET_SB_UPDATE_SCORE.invoke(entityId, objectiveId, scoreValue, Optional.of(NMSUtils.toMinecraftComponent(displayName)), Optional.of(format)) : PACKET_SB_UPDATE_SCORE.invoke(entityId, objectiveId, scoreValue, NMSUtils.toMinecraftComponent(displayName), format);
    }

    public static boolean isCustomScoreSupported() {
        return BLANK_NUMBER_FORMAT != null;
    }

    public static Optional<Class<?>> innerClass(Class<?> parentClass, Predicate<Class<?>> classPredicate) {
        for (Class<?> innerClass : parentClass.getDeclaredClasses()) {
            if (!classPredicate.test(innerClass)) continue;
            return Optional.of(innerClass);
        }
        return Optional.empty();
    }

    public static Object toMinecraftComponent(Component text) throws Throwable {
        if (text == null || text == Component.empty()) {
            return EMPTY_COMPONENT;
        }
        if (!ADVENTURE_SUPPORT || VERSION.isLowerThan(MinecraftVersion.V1_13)) {
            return Array.get(COMPONENT_METHOD.invoke(LegacyComponentSerializer.legacySection().serialize(text)), 0);
        }
        return COMPONENT_METHOD.invoke(text);
    }

    static void setComponentField(Object packet, Component component, int index) throws Throwable {
        if (VERSION.isLowerThan(MinecraftVersion.V1_13)) {
            NMSUtils.setField(packet, String.class, LegacyComponentSerializer.legacySection().serialize(Optional.ofNullable(component).orElse((Component)Component.empty())), index);
            return;
        }
        int i = 0;
        for (Field field : NMSUtils.getFieldsForPacket(packet.getClass())) {
            if (field.getType() != String.class && field.getType() != CHAT_COMPONENT_CLASS) continue;
            if (i == index) {
                field.set(packet, NMSUtils.toMinecraftComponent(component));
                return;
            }
            ++i;
        }
    }

    static void setField(Object packet, Class<?> fieldType, Object value) throws IllegalAccessException {
        NMSUtils.setField(packet, fieldType, value, 0);
    }

    static void setField(Object packet, Class<?> fieldType, Object value, int index) throws IllegalAccessException {
        int i = 0;
        for (Field field : NMSUtils.getFieldsForPacket(packet.getClass())) {
            if (field.getType() != fieldType) continue;
            if (i == index) {
                field.set(packet, value);
                return;
            }
            ++i;
        }
    }

    private static Field[] getFieldsForPacket(Class<?> clazz) {
        return PACKETS.computeIfAbsent(clazz, key -> {
            Field[] fields;
            for (Field field2 : fields = (Field[])Arrays.stream(clazz.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).toArray(Field[]::new)) {
                field2.setAccessible(true);
            }
            return fields;
        });
    }

    public static void sendPacket(Player target, Object packet) throws Throwable {
        if (!target.isOnline()) {
            return;
        }
        Object playerConnection = PLAYER_CONNECTION.invoke(PLAYER_GET_HANDLE.invoke(target));
        PLAYER_SEND_PACKET.invoke(playerConnection, packet);
    }

    public static Object createTeamPacket(String name, TeamMode mode) throws Throwable {
        return NMSUtils.createTeamPacket(name, mode, null, null, Collections.emptyList());
    }

    public static Object createTeamPacket(String name, TeamMode mode, Collection<String> entities) throws Throwable {
        return NMSUtils.createTeamPacket(name, mode, null, null, entities);
    }

    public static Object createTeamPacket(String name, TeamMode mode, Component prefix, Component suffix, Collection<String> entities) throws Throwable {
        return NMSUtils.createTeamPacket(name, mode, (Component)Component.empty(), (byte)0, NameTagVisibilityRule.ALWAYS, CollisionRule.ALWAYS, ChatFormatting.RESET, prefix, suffix, entities);
    }

    public static Object createTeamPacket(String name, TeamMode mode, Component displayName, byte friendlyFire, NameTagVisibilityRule nameTagVisibilityRule, CollisionRule collisionRule, ChatFormatting chatFormatting, Component prefix, Component suffix, Collection<String> entities) throws Throwable {
        Object packet = PACKET_SB_TEAM.createInstance();
        NMSUtils.setField(packet, String.class, name);
        NMSUtils.setField(packet, Integer.TYPE, mode.ordinal(), VERSION.isHigherThanOrEqual(MinecraftVersion.V1_8) && VERSION.isLowerThanOrEqual(MinecraftVersion.V1_8_9) ? 1 : 0);
        if (mode == TeamMode.ADD_PLAYERS || mode == TeamMode.REMOVE_PLAYERS) {
            NMSUtils.setField(packet, Collection.class, entities);
            return packet;
        }
        if (mode == TeamMode.REMOVE) {
            return packet;
        }
        if (VERSION.isHigherThanOrEqual(MinecraftVersion.V1_17)) {
            Object team = PACKET_SB_SERIALIZABLE_TEAM.createInstance();
            NMSUtils.setComponentField(team, displayName, 0);
            NMSUtils.setField(team, CHAT_FORMAT_ENUM, NMSUtils.findEnumValueOf(CHAT_FORMAT_ENUM, chatFormatting.name(), chatFormatting.ordinal()));
            NMSUtils.setField(team, Integer.TYPE, friendlyFire);
            NMSUtils.setComponentField(team, prefix, 1);
            NMSUtils.setComponentField(team, suffix, 2);
            NMSUtils.setField(team, String.class, nameTagVisibilityRule.getSerializedName(), 0);
            NMSUtils.setField(team, String.class, collisionRule.getSerializedName(), 1);
            NMSUtils.setField(team, ENUM_VISIBILITY, NMSUtils.findEnumValueOf(ENUM_VISIBILITY, nameTagVisibilityRule.name(), nameTagVisibilityRule.ordinal()), 0);
            NMSUtils.setField(team, ENUM_COLLISION_RULE, NMSUtils.findEnumValueOf(ENUM_COLLISION_RULE, collisionRule.name(), collisionRule.ordinal()), 0);
            NMSUtils.setField(packet, Optional.class, Optional.of(team));
        } else {
            NMSUtils.setComponentField(packet, displayName, 1);
            NMSUtils.setField(packet, Integer.TYPE, friendlyFire, 2);
            NMSUtils.setComponentField(packet, prefix, 2);
            NMSUtils.setComponentField(packet, suffix, 3);
            NMSUtils.setField(packet, String.class, nameTagVisibilityRule.getSerializedName(), 4);
            NMSUtils.setField(packet, String.class, collisionRule.getSerializedName(), 5);
        }
        if (mode == TeamMode.CREATE) {
            NMSUtils.setField(packet, Collection.class, entities);
        }
        return packet;
    }

    static {
        try {
            MethodHandle packetSbSetScore;
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> entityPlayerClass = NMSUtils.findNMSClass("server.level", "EntityPlayer", "ServerPlayer").orElseThrow();
            Class<?> playerConnectionClass = NMSUtils.findNMSClass("server.network", "PlayerConnection", "ServerGamePacketListenerImpl").orElseThrow();
            PLAYER_CONNECTION = lookup.unreflectGetter(Arrays.stream(entityPlayerClass.getFields()).filter(field -> field.getType().isAssignableFrom(playerConnectionClass)).findFirst().orElseThrow());
            Class<?> craftPlayerClass = NMSUtils.findOBCClass("entity.CraftPlayer").orElseThrow();
            PLAYER_GET_HANDLE = lookup.findVirtual(craftPlayerClass, "getHandle", MethodType.methodType(entityPlayerClass));
            Class<?> packetClass = NMSUtils.findNMSClass("network.protocol", "Packet").orElseThrow();
            PLAYER_SEND_PACKET = lookup.unreflect(Stream.concat(Arrays.stream(playerConnectionClass.getSuperclass().getMethods()), Arrays.stream(playerConnectionClass.getMethods())).filter(method -> method.getParameterCount() == 1 && method.getParameterTypes()[0] == packetClass).findFirst().orElseThrow());
            String gameProtocolPackage = "network.protocol.game";
            Class<?> packetSbObjClass = NMSUtils.findNMSClass(gameProtocolPackage, "PacketPlayOutScoreboardObjective", "ClientboundSetObjectivePacket").orElseThrow();
            PACKET_SB_UPDATE_OBJ = NMSUtils.findPacketConstructor(packetSbObjClass, lookup);
            DISPLAY_SLOT_TYPE = NMSUtils.findNMSClass("world.scores", "DisplaySlot").orElse(Integer.TYPE);
            IdentityHashMap<DisplaySlot, Object> displaySlotObjectMap = new IdentityHashMap<DisplaySlot, Object>();
            for (DisplaySlot slot : DisplaySlot.values()) {
                displaySlotObjectMap.put(slot, DISPLAY_SLOT_TYPE == Integer.TYPE ? Integer.valueOf(slot.getId()) : NMSUtils.findEnumValueOf(DISPLAY_SLOT_TYPE, slot.name(), slot.getId()));
            }
            DISPLAY_SLOT_OBJECT_MAP = Collections.unmodifiableMap(displaySlotObjectMap);
            RENDER_TYPE = NMSUtils.findNMSClass("world.scores.criteria", "IScoreboardCriteria$EnumScoreboardHealthDisplay", "ObjectiveCriteria$RenderType").orElseThrow();
            IdentityHashMap<ObjectiveRenderType, Object> renderTypeObjectMap = new IdentityHashMap<ObjectiveRenderType, Object>();
            for (ObjectiveRenderType type : ObjectiveRenderType.values()) {
                renderTypeObjectMap.put(type, NMSUtils.findEnumValueOf(RENDER_TYPE, type.name(), type.getId()));
            }
            RENDER_TYPE_OBJECT_MAP = Collections.unmodifiableMap(renderTypeObjectMap);
            Class<?> packetSbDisplayObjClass = NMSUtils.findNMSClass(gameProtocolPackage, "PacketPlayOutScoreboardDisplayObjective", "ClientboundSetDisplayObjectivePacket").orElseThrow();
            PACKET_SB_DISPLAY_OBJ = NMSUtils.findPacketConstructor(packetSbDisplayObjClass, lookup);
            CHAT_COMPONENT_CLASS = NMSUtils.findNMSClass("network.chat", "IChatBaseComponent", "Component").orElseThrow();
            ADVENTURE_SUPPORT = NMSUtils.optionalForName("io.papermc.paper.adventure.PaperAdventure").isPresent();
            if (ADVENTURE_SUPPORT) {
                Class<?> paperAdventureClass = Class.forName("io.papermc.paper.adventure.PaperAdventure");
                COMPONENT_METHOD = lookup.unreflect(paperAdventureClass.getDeclaredMethod("asVanilla", Component.class));
                EMPTY_COMPONENT = COMPONENT_METHOD.invoke(Component.empty());
            } else {
                Class<?> craftChatMessageClass = NMSUtils.findOBCClass("util.CraftChatMessage").orElseThrow();
                COMPONENT_METHOD = lookup.unreflect(craftChatMessageClass.getMethod("fromString", String.class));
                EMPTY_COMPONENT = Array.get(COMPONENT_METHOD.invoke(""), 0);
            }
            Class<?> packetSbTeamClass = NMSUtils.findNMSClass(gameProtocolPackage, "PacketPlayOutScoreboardTeam", "ClientboundSetPlayerTeamPacket").orElseThrow();
            Class<?> sbTeamClass = VERSION.isHigherThanOrEqual(MinecraftVersion.V1_17) ? NMSUtils.innerClass(packetSbTeamClass, clazz -> !clazz.isEnum()).orElseThrow() : null;
            PACKET_SB_TEAM = NMSUtils.findPacketConstructor(packetSbTeamClass, lookup);
            PACKET_SB_SERIALIZABLE_TEAM = sbTeamClass == null ? null : NMSUtils.findPacketConstructor(sbTeamClass, lookup);
            Class<?> packetSbScoreClass = NMSUtils.findNMSClass(gameProtocolPackage, "PacketPlayOutScoreboardScore", "ClientboundSetScorePacket").orElseThrow();
            CHAT_FORMAT_ENUM = NMSUtils.findNMSClass(null, "EnumChatFormat", "ChatFormatting").orElseThrow();
            MethodHandle packetSbResetScore = null;
            MethodHandle fixedFormatConstructor = null;
            MethodHandle styledFormatConstructor = null;
            Object blankNumberFormat = null;
            boolean scoreOptionalComponents = false;
            Object styleEmpty = null;
            MethodHandle styleWithColorRGB = null;
            MethodHandle styleWithBold = null;
            MethodHandle styleWithItalic = null;
            MethodHandle styleWithUnderline = null;
            MethodHandle styleWithStrikethrough = null;
            MethodHandle styleWithObfuscated = null;
            if (VERSION.isHigherThanOrEqual(MinecraftVersion.V1_20_3)) {
                Class<?> numberFormat = NMSUtils.findNMSClass("network.chat.numbers", "NumberFormat").orElseThrow();
                MethodType scoreType = MethodType.methodType(Void.TYPE, String.class, String.class, Integer.TYPE, CHAT_COMPONENT_CLASS, numberFormat);
                MethodType scoreTypeOptional = MethodType.methodType(Void.TYPE, String.class, String.class, Integer.TYPE, Optional.class, Optional.class);
                Class<?> resetScoreClass = NMSUtils.findNMSClass(gameProtocolPackage, "ClientboundResetScorePacket").orElseThrow();
                MethodType removeScoreType = MethodType.methodType(Void.TYPE, String.class, String.class);
                Optional<MethodHandle> optionalScorePacket = NMSUtils.findConstructor(packetSbScoreClass, lookup, scoreTypeOptional);
                packetSbSetScore = optionalScorePacket.isPresent() ? optionalScorePacket.get() : lookup.findConstructor(packetSbScoreClass, scoreType);
                scoreOptionalComponents = optionalScorePacket.isPresent();
                packetSbResetScore = lookup.findConstructor(resetScoreClass, removeScoreType);
                Class<?> fixedFormatClass = NMSUtils.findNMSClass("network.chat.numbers", "FixedFormat").orElseThrow();
                MethodType fixedFormatType = MethodType.methodType(Void.TYPE, CHAT_COMPONENT_CLASS);
                fixedFormatConstructor = lookup.findConstructor(fixedFormatClass, fixedFormatType);
                Class<?> styledFormat = NMSUtils.findNMSClass("network.chat.numbers", "StyledFormat").orElseThrow();
                Class<?> styleClass = NMSUtils.findNMSClass("network.chat", "Style").orElse(NMSUtils.findNMSClass("network.chat", "ChatModifier").orElseThrow());
                styleEmpty = lookup.findStaticVarHandle(styleClass, "a", styleClass).get();
                styleWithColorRGB = lookup.findVirtual(styleClass, "a", MethodType.methodType(styleClass, Integer.TYPE));
                styleWithBold = lookup.findVirtual(styleClass, "a", MethodType.methodType(styleClass, Boolean.class));
                styleWithItalic = lookup.findVirtual(styleClass, "b", MethodType.methodType(styleClass, Boolean.class));
                styleWithUnderline = lookup.findVirtual(styleClass, "c", MethodType.methodType(styleClass, Boolean.class));
                styleWithStrikethrough = lookup.findVirtual(styleClass, "d", MethodType.methodType(styleClass, Boolean.class));
                styleWithObfuscated = lookup.findVirtual(styleClass, "e", MethodType.methodType(styleClass, Boolean.class));
                MethodType styledFormatType = MethodType.methodType(Void.TYPE, styleClass);
                styledFormatConstructor = lookup.findConstructor(styledFormat, styledFormatType);
                Class<?> blankFormatClass = NMSUtils.findNMSClass("network.chat.numbers", "BlankFormat").orElseThrow();
                blankNumberFormat = Arrays.stream(blankFormatClass.getFields()).filter(field -> field.getType() == blankFormatClass).findAny().map(field -> {
                    try {
                        return field.get(null);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }).orElse(null);
            } else if (VERSION.isHigherThanOrEqual(MinecraftVersion.V1_17)) {
                Class<?> enumSbAction = NMSUtils.findNMSClass("server", "ScoreboardServer$Action", "ServerScoreboard$Method").orElseThrow();
                MethodType scoreType = MethodType.methodType(Void.TYPE, enumSbAction, String.class, String.class, Integer.TYPE);
                packetSbSetScore = lookup.findConstructor(packetSbScoreClass, scoreType);
            } else {
                packetSbSetScore = lookup.findConstructor(packetSbScoreClass, MethodType.methodType(Void.TYPE));
            }
            if (VERSION.isHigherThanOrEqual(MinecraftVersion.V1_17)) {
                ENUM_VISIBILITY = NMSUtils.findNMSClass("world.scores", "ScoreboardTeamBase$EnumNameTagVisibility", "Team$Visibility").orElseThrow();
                ENUM_COLLISION_RULE = NMSUtils.findNMSClass("world.scores", "ScoreboardTeamBase$EnumTeamPush", "Team$CollisionRule").orElseThrow();
                ENUM_VISIBILITY_ALWAYS = NMSUtils.findEnumValueOf(ENUM_VISIBILITY, "ALWAYS", 0);
                ENUM_COLLISION_RULE_ALWAYS = NMSUtils.findEnumValueOf(ENUM_COLLISION_RULE, "ALWAYS", 0);
            } else {
                ENUM_VISIBILITY = null;
                ENUM_COLLISION_RULE = null;
                ENUM_VISIBILITY_ALWAYS = null;
                ENUM_COLLISION_RULE_ALWAYS = null;
            }
            PACKET_SB_UPDATE_SCORE = packetSbSetScore;
            PACKET_SB_RESET_SCORE = packetSbResetScore;
            SCORE_OPTIONAL_COMPONENTS = scoreOptionalComponents;
            FIXED_NUMBER_FORMAT = fixedFormatConstructor;
            STYLE_NUMBER_FORMAT = styledFormatConstructor;
            BLANK_NUMBER_FORMAT = blankNumberFormat;
            EMPTY_STYLE = styleEmpty;
            STYLE_METHOD_WITH_COLOR_RGB = styleWithColorRGB;
            STYLE_METHOD_WITH_BOLD = styleWithBold;
            STYLE_METHOD_WITH_ITALIC = styleWithItalic;
            STYLE_METHOD_WITH_UNDERLINE = styleWithUnderline;
            STYLE_METHOD_WITH_STRIKETHROUGH = styleWithStrikethrough;
            STYLE_METHOD_WITH_OBFUSCATED = styleWithObfuscated;
            ENUM_SB_ACTION = NMSUtils.findNMSClass("server", VERSION.isHigherThanOrEqual(MinecraftVersion.V1_13) ? "ScoreboardServer$Action" : "PacketPlayOutScoreboardScore$EnumScoreboardAction", "ServerScoreboard$Method").orElseThrow();
            ENUM_SB_ACTION_CHANGE = NMSUtils.findEnumValueOf(ENUM_SB_ACTION, "CHANGE", 0);
            ENUM_SB_ACTION_REMOVE = NMSUtils.findEnumValueOf(ENUM_SB_ACTION, "REMOVE", 1);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface PacketConstructor {
        public Object createInstance() throws Throwable;
    }
}

