/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot.inventory;

import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public enum ArmorSlot {
    HELMET(5),
    CHESTPLATE(6),
    LEGGINGS(7),
    BOOTS(8);

    private final int slot;

    private ArmorSlot(int slot) {
        this.slot = slot;
    }

    @Nullable
    public static ArmorSlot getArmorSlotType(ItemStack item) {
        if (item == null) {
            return null;
        }
        return ArmorSlot.getArmorSlotType(item.getType());
    }

    @Nullable
    public static ArmorSlot getArmorSlotType(Material type) {
        String typeName = type.name();
        if (typeName.endsWith("_HELMET") || typeName.endsWith("_SKULL") || typeName.endsWith("_HEAD") || typeName.endsWith("CARVED_PUMPKIN")) {
            return HELMET;
        }
        if (typeName.endsWith("_CHESTPLATE") || typeName.equals("ELYTRA")) {
            return CHESTPLATE;
        }
        if (typeName.endsWith("_LEGGINGS")) {
            return LEGGINGS;
        }
        if (typeName.endsWith("_BOOTS")) {
            return BOOTS;
        }
        return null;
    }

    public int getSlot() {
        return this.slot;
    }
}

