/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot;

import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class ServerInfoStore {
    private static ServerInfoStore instance;
    private final String packageName = Bukkit.getServer().getClass().getPackage().getName();
    private final String serverVersion = this.packageName.substring(this.packageName.lastIndexOf(".") + 1);
    private Boolean containsVersion = null;

    public static ServerInfoStore getInstance() {
        return instance == null ? (instance = new ServerInfoStore()) : instance;
    }

    @TestOnly
    public static void flush() {
        instance = null;
    }

    public String getOBCPackageName() {
        return this.packageName;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public boolean containsVersion() {
        if (this.containsVersion != null) {
            return this.containsVersion;
        }
        try {
            Method method = Bukkit.getServer().getClass().getMethod("getHandle", new Class[0]);
            this.containsVersion = method.getReturnType().getName().contains(this.serverVersion);
            return this.containsVersion;
        }
        catch (NoSuchMethodException e) {
            String className = Bukkit.getServer().getClass().getName();
            throw new RuntimeException("Could not find method getHandle of class %s".formatted(className), e);
        }
    }
}

