/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.scoreboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.apartium.cocoabeans.Ensures;
import net.apartium.cocoabeans.scoreboard.ObjectiveMode;
import net.apartium.cocoabeans.scoreboard.ScoreboardAction;
import net.apartium.cocoabeans.scoreboard.TeamMode;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.state.Observer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.39")
public abstract class CocoaBoard {
    public static final int MAX_LINES = 15;
    protected final String objectiveId;
    private final List<ComponentEntry> lines = new ArrayList<ComponentEntry>();
    private final List<ComponentEntry> scores = new ArrayList<ComponentEntry>();
    private final List<Style> numberStyles = new ArrayList<Style>();
    protected final boolean isCustomScoreSupported;
    private ComponentEntry title;

    protected CocoaBoard(String objectiveId, Observable<Component> title, boolean isCustomScoreSupported) {
        this.objectiveId = objectiveId;
        this.title = ComponentEntry.create(title);
        this.isCustomScoreSupported = isCustomScoreSupported;
    }

    protected void createBoardAndDisplay() {
        this.sendObjectivePacket(ObjectiveMode.CREATE, this.title.component);
        this.sendDisplayPacket();
    }

    public void setDisplay() {
        this.sendDisplayPacket();
    }

    private void ensuresLineNumber(int score, boolean ensureInRange, boolean ensuresMax) {
        Ensures.largerThan(score, 0, new IllegalArgumentException("Line must be positive number"));
        if (ensureInRange) {
            Ensures.largerThan(this.lines.size(), score, new IllegalArgumentException("Line must be under " + this.lines.size()));
        }
        if (ensuresMax) {
            Ensures.largerThan(15, score, new IllegalArgumentException("Line must be at most 15"));
        }
    }

    public void heartbeat() {
        ComponentEntry entry;
        int score;
        if (this.title != null && this.title.hasChange()) {
            this.updateTitle();
        }
        for (score = 0; score < this.lines.size(); ++score) {
            entry = this.lines.get(score);
            if (entry == null || !entry.hasChange()) continue;
            entry.clean();
            this.sendLineChange(this.getScoreByLine(score), entry, TeamMode.UPDATE);
        }
        if (this.isCustomScoreSupported) {
            for (score = 0; score < this.scores.size(); ++score) {
                entry = this.scores.get(score);
                if (entry == null || !entry.hasChange()) continue;
                entry.clean();
                this.sendScorePacket(score, entry.component, ScoreboardAction.CREATE_OR_UPDATE, null);
            }
        }
    }

    public void line(int line, Component component) {
        this.line(line, CocoaBoard.toObservable(component));
    }

    public void line(int line, Observable<Component> component) {
        this.line(line, component, null);
    }

    public void line(int line, Component component, Component scoreDisplay) {
        this.line(line, CocoaBoard.toObservable(component), CocoaBoard.toObservable(scoreDisplay));
    }

    public void line(int line, Observable<Component> component, Observable<Component> scoreDisplay) {
        this.line(line, component, scoreDisplay, null);
    }

    public void line(int line, Component component, Component scoreDisplay, Style numberStyle) {
        this.line(line, CocoaBoard.toObservable(component), CocoaBoard.toObservable(scoreDisplay), numberStyle);
    }

    public void line(int line, Observable<Component> component, Observable<Component> scoreDisplay, Style numberStyle) {
        this.ensuresLineNumber(line, false, false);
        if (line < this.lines.size()) {
            ComponentEntry entry = ComponentEntry.create(component);
            if (this.hasChange(this.lines.get(line), entry)) {
                this.lines.set(line, entry);
                this.sendLineChange(this.getScoreByLine(line));
            }
            if (this.isCustomScoreSupported) {
                ComponentEntry scoreEntry = ComponentEntry.create(scoreDisplay);
                if (!this.hasChange(this.scores.get(line), scoreEntry) || Objects.equals(this.numberStyles.get(line), numberStyle)) {
                    return;
                }
                this.scores.set(line, scoreEntry);
                this.numberStyles.set(line, numberStyle);
                int score = this.getScoreByLine(line);
                this.sendScorePacket(score, scoreDisplay, ScoreboardAction.CREATE_OR_UPDATE, numberStyle);
            }
            return;
        }
        ArrayList<ComponentEntry> newLines = new ArrayList<ComponentEntry>(this.lines);
        ArrayList<ComponentEntry> newScores = new ArrayList<ComponentEntry>(this.scores);
        ArrayList<Style> newNumberStyles = new ArrayList<Style>(this.numberStyles);
        if (line > this.lines.size()) {
            for (int i = this.lines.size(); i < line; ++i) {
                newLines.add(ComponentEntry.create(Observable.empty()));
                newScores.add(null);
                newNumberStyles.add(null);
            }
        }
        newLines.add(ComponentEntry.create(component));
        newScores.add(ComponentEntry.create(scoreDisplay));
        newNumberStyles.add(numberStyle);
        this.lines0(newLines, newScores, newNumberStyles);
    }

    public void add(Component component) {
        this.add(CocoaBoard.toObservable(component));
    }

    public void add(Observable<Component> component) {
        this.add(component, null);
    }

    public void add(Component component, Component scoreDisplay) {
        this.add(CocoaBoard.toObservable(component), CocoaBoard.toObservable(scoreDisplay));
    }

    public void add(Observable<Component> component, Observable<Component> scoreDisplay) {
        this.add(component, scoreDisplay, null);
    }

    public void add(Component component, Component scoreDisplay, Style numberStyle) {
        this.add(CocoaBoard.toObservable(component), scoreDisplay == null ? null : CocoaBoard.toObservable(scoreDisplay), numberStyle);
    }

    public void add(Observable<Component> component, Observable<Component> scoreDisplay, Style numberStyle) {
        ArrayList<ComponentEntry> newLines = new ArrayList<ComponentEntry>(this.lines);
        ArrayList<ComponentEntry> newScores = new ArrayList<ComponentEntry>(this.scores);
        ArrayList<Style> newNumberStyles = new ArrayList<Style>(this.numberStyles);
        newLines.add(ComponentEntry.create(component));
        newScores.add(ComponentEntry.create(scoreDisplay));
        newNumberStyles.add(numberStyle);
        this.lines0(newLines, newScores, newNumberStyles);
    }

    public void add(Component component, int offsetLine) {
        this.add(CocoaBoard.toObservable(component), offsetLine);
    }

    public void add(Observable<Component> component, int offsetLine) {
        this.add(component, null, offsetLine);
    }

    public void add(Component component, Component scoreDisplay, int offsetLine) {
        this.add(CocoaBoard.toObservable(component), CocoaBoard.toObservable(scoreDisplay), offsetLine);
    }

    public void add(Observable<Component> component, Observable<Component> scoreDisplay, int offsetLine) {
        this.add(component, scoreDisplay, null, offsetLine);
    }

    public void add(Component component, Component scoreDisplay, Style numberStyle, int offsetLine) {
        this.add(CocoaBoard.toObservable(component), CocoaBoard.toObservable(scoreDisplay), numberStyle, offsetLine);
    }

    public void add(Observable<Component> component, Observable<Component> scoreDisplay, Style numberStyle, int offsetLine) {
        ArrayList<ComponentEntry> newLines = new ArrayList<ComponentEntry>(this.lines);
        ArrayList<ComponentEntry> newScores = new ArrayList<ComponentEntry>(this.scores);
        ArrayList<Style> newNumberStyles = new ArrayList<Style>(this.numberStyles);
        newLines.add(offsetLine, ComponentEntry.create(component));
        newScores.add(offsetLine, ComponentEntry.create(scoreDisplay));
        newNumberStyles.add(offsetLine, numberStyle);
        this.lines0(newLines, newScores, newNumberStyles);
    }

    public void remove(int line) {
        this.ensuresLineNumber(line, true, false);
        ArrayList<ComponentEntry> newLines = new ArrayList<ComponentEntry>(this.lines);
        ArrayList<ComponentEntry> newScores = new ArrayList<ComponentEntry>(this.scores);
        ArrayList<Style> newNumberStyles = new ArrayList<Style>(this.numberStyles);
        newLines.remove(line);
        newScores.remove(line);
        newNumberStyles.remove(line);
        this.lines0(newLines, newScores, newNumberStyles);
    }

    public void updateLines(Collection<Component> lines) {
        this.lines(lines.stream().map(c -> c == Component.empty() ? Observable.empty() : Observable.immutable(c)).toList());
    }

    public void updateLines(Collection<Component> lines, Collection<Component> scores) {
        this.lines(lines.stream().map(c -> c == Component.empty() ? Observable.empty() : Observable.immutable(c)).toList(), scores.stream().map(c -> c == Component.empty() ? Observable.empty() : Observable.immutable(c)).toList());
    }

    public void updateLines(Collection<Component> lines, Collection<Component> scores, Collection<Style> numberStyles) {
        this.lines(lines.stream().map(c -> c == Component.empty() ? Observable.empty() : Observable.immutable(c)).toList(), scores.stream().map(c -> c == Component.empty() ? Observable.empty() : Observable.immutable(c)).toList(), numberStyles);
    }

    public void lines(Collection<Observable<Component>> lines) {
        this.lines(lines, null);
    }

    public void lines(Collection<Observable<Component>> lines, Collection<Observable<Component>> scores) {
        this.lines(lines, scores, null);
    }

    public void lines(Collection<Observable<Component>> lines, Collection<Observable<Component>> scores, Collection<Style> numberStyles) {
        Ensures.notNull(lines, "Lines must be non-null");
        if (scores != null && lines.size() != scores.size()) {
            throw new IllegalArgumentException("Scores and lines must be the same size");
        }
        if (numberStyles != null && lines.size() != numberStyles.size()) {
            throw new IllegalArgumentException("Number styles and line must be the same size");
        }
        this.lines0(lines.stream().map(ComponentEntry::create).toList(), scores == null ? null : scores.stream().map(ComponentEntry::create).toList(), numberStyles);
    }

    public void title(Component component) {
        this.title(CocoaBoard.toObservable(component));
    }

    public void title(Observable<Component> component) {
        this.title = ComponentEntry.create(component);
        this.updateTitle();
    }

    public void numberStyle(int line, Style style) {
        this.ensuresLineNumber(line, true, true);
        ArrayList<ComponentEntry> newLines = new ArrayList<ComponentEntry>(this.lines);
        ArrayList<ComponentEntry> newScores = new ArrayList<ComponentEntry>(this.scores);
        ArrayList<Style> newNumberStyles = new ArrayList<Style>(this.numberStyles);
        newNumberStyles.set(line, style);
        this.lines0(newLines, newScores, newNumberStyles);
    }

    private boolean hasChange(ComponentEntry a, ComponentEntry b) {
        return !Objects.equals(a, b) || a != null && a.hasChange();
    }

    private void lines0(Collection<ComponentEntry> lines, Collection<ComponentEntry> scores, Collection<Style> numberStyles) {
        int linesSize;
        this.ensuresLineNumber(lines.size(), false, true);
        if (scores != null && scores.size() != lines.size()) {
            throw new IllegalArgumentException("The size of the score must match the size of the lines");
        }
        if (numberStyles != null && numberStyles.size() != lines.size()) {
            throw new IllegalArgumentException("The size of the styles");
        }
        ArrayList<ComponentEntry> oldLines = new ArrayList<ComponentEntry>(this.lines);
        this.lines.clear();
        this.lines.addAll(lines);
        ArrayList<ComponentEntry> oldScores = new ArrayList<ComponentEntry>(this.scores);
        this.scores.clear();
        this.scores.addAll(scores != null ? scores : Collections.nCopies(lines.size(), null));
        ArrayList<Style> oldNumberStyles = new ArrayList<Style>(this.numberStyles);
        this.numberStyles.clear();
        this.numberStyles.addAll(numberStyles != null ? numberStyles : Collections.nCopies(lines.size(), null));
        int end = linesSize = this.lines.size();
        if (oldLines.size() != linesSize) {
            end = this.handleNotSameSize(oldLines, linesSize);
        }
        for (int i = 0; i < end; ++i) {
            if (this.hasChange(this.getLineByScore(oldLines, i), this.getLineByScore(i))) {
                Optional.ofNullable(this.getLineByScore(i)).ifPresent(ComponentEntry::clean);
                this.sendLineChange(i);
            }
            if (!this.hasChange(this.getLineByScore(oldScores, i), this.getLineByScore(this.scores, i)) && Objects.equals(this.getLineByScore(oldNumberStyles, i), this.getLineByScore(this.numberStyles, i))) continue;
            Optional.ofNullable(this.getLineByScore(this.scores, i)).ifPresent(ComponentEntry::clean);
            this.sendScorePacket(i, Optional.ofNullable(this.getLineByScore(this.scores, i)).map(ComponentEntry::component).orElse(null), ScoreboardAction.CREATE_OR_UPDATE, this.getLineByScore(this.numberStyles, i));
        }
    }

    private int handleNotSameSize(List<ComponentEntry> oldLines, int linesSize) {
        ArrayList<ComponentEntry> oldLinesCopy = new ArrayList<ComponentEntry>(oldLines);
        if (oldLines.size() > linesSize) {
            for (int i = oldLinesCopy.size(); i > linesSize; --i) {
                int score = i - 1;
                this.sendTeamPacket(score, TeamMode.REMOVE, null, null);
                this.sendScorePacket(score, null, ScoreboardAction.REMOVE, null);
                oldLines.remove(0);
            }
            return linesSize;
        }
        for (int i = oldLinesCopy.size(); i < linesSize; ++i) {
            this.sendScorePacket(i, Optional.ofNullable(this.getLineByScore(this.scores, i)).map(c -> c.component).orElse(null), ScoreboardAction.CREATE_OR_UPDATE, this.getLineByScore(this.numberStyles, i));
            this.sendLineChange(i, TeamMode.CREATE);
        }
        return oldLines.size();
    }

    protected int getScoreByLine(int line) {
        return this.lines.size() - line - 1;
    }

    protected ComponentEntry getLineByScore(int score) {
        return this.getLineByScore(this.lines, score);
    }

    protected <E> E getLineByScore(List<E> lines, int score) {
        return score < lines.size() ? (E)lines.get(lines.size() - score - 1) : null;
    }

    private void updateTitle() {
        if (this.title == null) {
            return;
        }
        this.sendObjectivePacket(ObjectiveMode.UPDATE, this.title.component);
        this.title.clean();
    }

    public void delete() {
        for (int i = 0; i < this.lines.size(); ++i) {
            this.sendTeamPacket(i, TeamMode.REMOVE, null, null);
        }
        this.sendObjectivePacket(ObjectiveMode.REMOVE, null);
        this.lines.forEach(line -> {
            if (line == null) {
                return;
            }
            line.delete();
        });
        this.lines.clear();
        this.scores.forEach(score -> {
            if (score == null) {
                return;
            }
            score.delete();
        });
        this.scores.clear();
        this.numberStyles.clear();
    }

    public static Observable<Component> toObservable(Component component) {
        if (component == null) {
            return null;
        }
        if (component == Component.empty()) {
            return Observable.empty();
        }
        return Observable.immutable(component);
    }

    protected String intoTeamName(int score) {
        return this.objectiveId + ":" + score;
    }

    protected abstract void sendObjectivePacket(ObjectiveMode var1, Observable<Component> var2);

    protected abstract void sendDisplayPacket();

    protected abstract void sendScorePacket(int var1, Observable<Component> var2, ScoreboardAction var3, Style var4);

    protected abstract void sendTeamPacket(int var1, TeamMode var2, Observable<Component> var3, Observable<Component> var4);

    protected abstract void sendLineChange(int var1, ComponentEntry var2, TeamMode var3);

    protected void sendLineChange(int score, TeamMode mode) {
        this.sendLineChange(score, this.getLineByScore(score), mode);
    }

    protected void sendLineChange(int score) {
        this.sendLineChange(score, TeamMode.UPDATE);
    }

    protected static class ComponentEntry
    implements Observer {
        private final Observable<Component> component;
        private boolean isDirty;
        private Component prevComponent = null;

        private static ComponentEntry create(Observable<Component> component) {
            if (component == null) {
                return null;
            }
            ComponentEntry componentEntry = new ComponentEntry(component);
            component.observe(componentEntry);
            return componentEntry;
        }

        private ComponentEntry(Observable<Component> component) {
            this.component = component;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ComponentEntry other = (ComponentEntry)obj;
            if (this.component != other.component) {
                return false;
            }
            return this.isDirty() == other.isDirty();
        }

        public int hashCode() {
            return Objects.hash(this.component, this.isDirty);
        }

        @Override
        public void flagAsDirty(Observable<?> observable) {
            if (this.component != observable) {
                return;
            }
            this.isDirty = true;
        }

        public void delete() {
            this.component.removeObserver(this);
            this.prevComponent = null;
        }

        public void clean() {
            this.isDirty = false;
            this.prevComponent = this.component.get();
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public boolean hasChange() {
            if (!this.isDirty) {
                return false;
            }
            return !Objects.equals(this.prevComponent, this.component.get());
        }

        public Observable<Component> component() {
            return this.component;
        }
    }
}

