/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.encode;

import net.apartium.cocoabeans.encode.BaseConverter;

class Base32Converter
implements BaseConverter {
    private static final String BASE32_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final int[] BASE32_LOOKUP = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 26, 27, 28, 29, 30, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    static final Base32Converter INSTANCE = new Base32Converter();

    private Base32Converter() {
    }

    @Override
    public String encode(byte[] data) {
        StringBuilder result = new StringBuilder((data.length + 7) / 8 * 5);
        int i = 0;
        int index = 0;
        while (i < data.length) {
            int digit;
            int currByte;
            int n = currByte = data[i] >= 0 ? data[i] : data[i] + 256;
            if (index > 3) {
                int nextByte = i + 1 < data.length ? (data[i + 1] >= 0 ? data[i + 1] : data[i + 1] + 256) : 0;
                digit = currByte & 255 >> index;
                index = (index + 5) % 8;
                digit <<= index;
                digit |= nextByte >> 8 - index;
                ++i;
            } else {
                digit = currByte >> 8 - (index + 5) & 0x1F;
                if ((index = (index + 5) % 8) == 0) {
                    ++i;
                }
            }
            result.append(BASE32_CHARS.charAt(digit));
        }
        result.append("=".repeat((8 - result.length() % 8) % 8));
        return result.toString();
    }

    @Override
    public byte[] decode(String data) {
        int length = data.length();
        if (length == 0) {
            return new byte[0];
        }
        for (int i = length - 1; i >= 0 && data.charAt(i) == '='; --i) {
            --length;
        }
        int numBytes = length * 5 / 8;
        byte[] result = new byte[numBytes];
        int buffer = 0;
        int bitsLeft = 0;
        int index = 0;
        for (char c : data.toCharArray()) {
            if (c == '=') break;
            int lookup = BASE32_LOOKUP[c];
            if (lookup == 255) {
                throw new IllegalArgumentException("Illegal character: " + c);
            }
            buffer <<= 5;
            buffer |= lookup & 0x1F;
            if ((bitsLeft += 5) < 8) continue;
            result[index++] = (byte)(buffer >> bitsLeft - 8 & 0xFF);
            bitsLeft -= 8;
        }
        return result;
    }
}

