/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.spigot.requirements.factory;

import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.apartium.cocoabeans.commands.GenericNode;
import net.apartium.cocoabeans.commands.requirements.Requirement;
import net.apartium.cocoabeans.commands.requirements.RequirementEvaluationContext;
import net.apartium.cocoabeans.commands.requirements.RequirementFactory;
import net.apartium.cocoabeans.commands.requirements.RequirementResult;
import net.apartium.cocoabeans.commands.requirements.UnmetRequirementResponse;
import net.apartium.cocoabeans.commands.spigot.exception.WhitelistException;
import net.apartium.cocoabeans.commands.spigot.requirements.Whitelist;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class WhitelistRequirementFactory
implements RequirementFactory {
    @Override
    @Nullable
    public Requirement getRequirement(GenericNode node, Object obj) {
        if (!(obj instanceof Whitelist)) {
            return null;
        }
        Whitelist whitelist = (Whitelist)obj;
        return new WhitelistRequirementImpl(whitelist, Arrays.stream(whitelist.value()).map(UUID::fromString).collect(Collectors.toSet()), whitelist.consoleBypass(), whitelist.invert());
    }

    private static class WhitelistRequirementImpl
    implements Requirement {
        private final Whitelist whitelist;
        private final Set<UUID> uuids;
        private final boolean consoleBypass;
        private final boolean invert;

        public WhitelistRequirementImpl(Whitelist whitelist, Set<UUID> uuids, boolean consoleBypass, boolean invert) {
            this.whitelist = whitelist;
            this.uuids = uuids;
            this.consoleBypass = consoleBypass;
            this.invert = invert;
        }

        @Override
        public RequirementResult meetsRequirement(RequirementEvaluationContext context) {
            Object senderObj = context.sender().getSender();
            if (senderObj == null) {
                return this.invert ? RequirementResult.meet() : RequirementResult.error(new UnmetWhitelistResponse(this, context, "Sender is null"));
            }
            if (!(senderObj instanceof Player)) {
                return (this.consoleBypass && senderObj instanceof ConsoleCommandSender) != this.invert ? RequirementResult.meet() : RequirementResult.error(new UnmetWhitelistResponse(this, context, this.invert ? "Invert console by pass lolllllllllll" : "Sender is not a player"));
            }
            Player player = (Player)senderObj;
            return this.uuids.contains(player.getUniqueId()) != this.invert ? RequirementResult.meet() : RequirementResult.error(new UnmetWhitelistResponse(this, context, "Sender is " + (this.invert ? "in the blacklist" : "not whitelisted")));
        }

        private class UnmetWhitelistResponse
        extends UnmetRequirementResponse {
            public UnmetWhitelistResponse(Requirement requirement, RequirementEvaluationContext context, String message) {
                super(requirement, context, message, WhitelistRequirementImpl.this.whitelist);
            }

            @Override
            public WhitelistException getError() {
                return new WhitelistException((UnmetRequirementResponse)this, WhitelistRequirementImpl.this.whitelist);
            }
        }
    }
}

