/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.spigot.parsers;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.ApiStatus;

public class OfflinePlayerParser
extends ArgumentParser<OfflinePlayer> {
    public static final String DEFAULT_KEYWORD = "offlineplayer";

    @ApiStatus.AvailableSince(value="0.0.36")
    public OfflinePlayerParser(int priority, String keyword) {
        super(keyword, OfflinePlayer.class, priority);
    }

    public OfflinePlayerParser(int priority) {
        this(priority, DEFAULT_KEYWORD);
    }

    @Override
    public Optional<ArgumentParser.ParseResult<OfflinePlayer>> parse(CommandProcessingContext processingContext) {
        int startIndex;
        List<String> args = processingContext.args();
        OfflinePlayer player = Bukkit.getOfflinePlayerIfCached((String)args.get(startIndex = processingContext.index()));
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of(new ArgumentParser.ParseResult<OfflinePlayer>(player, startIndex + 1));
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        int startIndex;
        List<String> args = processingContext.args();
        if (Bukkit.getOfflinePlayerIfCached((String)args.get(startIndex = processingContext.index())) == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(startIndex + 1);
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        int startIndex = processingContext.index();
        return Optional.of(new ArgumentParser.TabCompletionResult(Arrays.stream(Bukkit.getOfflinePlayers()).map(OfflinePlayer::getName).filter(Objects::nonNull).filter(s -> s.toLowerCase().startsWith(((String)args.get(startIndex)).toLowerCase())).collect(Collectors.toSet()), startIndex + 1));
    }
}

