/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.spigot.parsers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import org.bukkit.Material;
import org.jetbrains.annotations.ApiStatus;

public class MaterialParser
extends ArgumentParser<Material> {
    public static final String DEFAULT_KEYWORD = "material";

    @ApiStatus.AvailableSince(value="0.0.36")
    public MaterialParser(int priority, String keyword) {
        super(keyword, Material.class, priority);
    }

    public MaterialParser(int priority) {
        this(priority, DEFAULT_KEYWORD);
    }

    @Override
    public Optional<ArgumentParser.ParseResult<Material>> parse(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        int startIndex = processingContext.index();
        Optional<Material> materialOpt = this.findMaterial(args.get(startIndex));
        return materialOpt.map(material -> new ArgumentParser.ParseResult<Material>((Material)material, startIndex + 1));
    }

    private Optional<Material> findMaterial(String name) {
        if (!name.contains("_")) {
            return Arrays.stream(Material.values()).filter(material -> material.name().replace("_", "").equalsIgnoreCase(name)).findFirst();
        }
        return Optional.ofNullable(Material.getMaterial((String)name.toUpperCase()));
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        if (args.isEmpty()) {
            return OptionalInt.empty();
        }
        int startIndex = processingContext.index();
        if (this.findMaterial(args.get(startIndex)).isEmpty()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(startIndex + 1);
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        int startIndex = processingContext.index();
        String arg = args.get(startIndex);
        HashSet<String> result = new HashSet<String>();
        for (Material material : Material.values()) {
            String name = material.name().toLowerCase();
            if (!arg.contains("_")) {
                name = name.replace("_", "");
            }
            if (!name.startsWith(arg.toLowerCase())) continue;
            result.add(name);
        }
        return Optional.of(new ArgumentParser.TabCompletionResult(Collections.unmodifiableSet(result), startIndex + 1));
    }
}

