/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.spigot;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import net.apartium.cocoabeans.commands.ArgumentMapper;
import net.apartium.cocoabeans.commands.Command;
import net.apartium.cocoabeans.commands.CommandContext;
import net.apartium.cocoabeans.commands.CommandManager;
import net.apartium.cocoabeans.commands.CommandNode;
import net.apartium.cocoabeans.commands.Description;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.Usage;
import net.apartium.cocoabeans.commands.lexer.CommandLexer;
import net.apartium.cocoabeans.commands.lexer.SimpleCommandLexer;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.spigot.SpigotArgumentMapper;
import net.apartium.cocoabeans.commands.spigot.SpigotSender;
import net.apartium.cocoabeans.commands.spigot.parsers.GameModeParser;
import net.apartium.cocoabeans.commands.spigot.parsers.LocationParser;
import net.apartium.cocoabeans.commands.spigot.parsers.MaterialParser;
import net.apartium.cocoabeans.commands.spigot.parsers.OfflinePlayerParser;
import net.apartium.cocoabeans.commands.spigot.parsers.PlayerParser;
import net.apartium.cocoabeans.commands.spigot.parsers.PluginParser;
import net.apartium.cocoabeans.commands.spigot.parsers.WorldParser;
import net.apartium.cocoabeans.commands.spigot.requirements.Permission;
import net.apartium.cocoabeans.commands.virtual.VirtualCommandDefinition;
import net.apartium.cocoabeans.spigot.Commands;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class SpigotCommandManager
extends CommandManager {
    public static final Set<ArgumentParser<?>> SPIGOT_PARSERS = Set.of(new PlayerParser(0), new OfflinePlayerParser(0), new MaterialParser(0), new LocationParser(0), new GameModeParser(0), new WorldParser(0), new PluginParser(0));
    private final JavaPlugin plugin;

    public SpigotCommandManager(JavaPlugin plugin) {
        this(plugin, new SpigotArgumentMapper());
    }

    public SpigotCommandManager(JavaPlugin plugin, ArgumentMapper argumentMapper) {
        this(plugin, plugin.getLogger(), argumentMapper, new SimpleCommandLexer());
    }

    @ApiStatus.AvailableSince(value="0.0.41")
    public SpigotCommandManager(JavaPlugin plugin, Logger logger, ArgumentMapper argumentMapper, CommandLexer commandLexer) {
        super(logger, argumentMapper, commandLexer);
        this.plugin = plugin;
    }

    @Override
    protected void addCommand(CommandNode commandNode, Command command) {
        this.intoBukkitCommand(command.value(), List.of(command.aliases()), Optional.ofNullable(commandNode.getClass().getAnnotation(Description.class)).map(Description::value).orElse(""), Optional.ofNullable(commandNode.getClass().getAnnotation(Usage.class)).map(Usage::value).orElse(""), Optional.ofNullable(commandNode.getClass().getAnnotation(Permission.class)).map(Permission::value).orElse(null));
    }

    @Override
    public void addVirtualCommand(VirtualCommandDefinition definition, Function<CommandContext, Boolean> callback) {
        super.addVirtualCommand(definition, callback);
        this.intoBukkitCommand(definition.name(), List.copyOf(definition.aliases()), definition.info().getDescription().orElse(""), definition.info().getUsage().orElse(""), Optional.ofNullable(definition.metadata().get("permission")).map(Object::toString).orElse(null));
    }

    private void intoBukkitCommand(String name, List<String> aliases, String description, String usage, String permission) {
        org.bukkit.command.Command cmd = new org.bukkit.command.Command(name, description, usage, aliases){

            public boolean execute(CommandSender sender, String invoke, String[] args) {
                String[] split = invoke.split(":");
                invoke = split[1 % split.length];
                try {
                    return SpigotCommandManager.this.handle(new SpigotSender<CommandSender>(sender), invoke, args);
                }
                catch (Throwable e) {
                    return false;
                }
            }

            @NotNull
            public List<String> tabComplete(CommandSender sender, String invoke, String[] args) {
                String[] split = invoke.split(":");
                invoke = split[1 % split.length];
                return SpigotCommandManager.this.handleTabComplete(new SpigotSender<CommandSender>(sender), invoke, args);
            }
        };
        if (permission != null) {
            cmd.setPermission(permission);
        }
        Commands.getCommandMap().register(this.plugin.getName().toLowerCase(), cmd);
    }

    @Override
    public boolean handle(Sender sender, String commandName, String[] args) throws Throwable {
        return super.handle(sender, commandName, args);
    }
}

